% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{edge_options}
\alias{edge_options}
\title{Create Edge Options Configuration for G6 Graphs}
\usage{
edge_options(
  type = c("line", "polyline", "arc", "quadratic", "cubic", "cubic-vertical",
    "cubic-horizontal", "loop"),
  style = edge_style_options(),
  state = NULL,
  palette = NULL,
  animation = NULL
)
}
\arguments{
\item{type}{Edge type. Can be a built-in edge type name or a custom edge name.
Built-in types include "line", "polyline", "arc", "quadratic", "cubic", "cubic-vertical",
"cubic-horizontal", "loop", etc. Default: "line".}

\item{style}{Edge style configuration. Controls the appearance of edges including color,
width, dash patterns, etc. Can be created with \code{edge_style_options()}.
Default: NULL.}

\item{state}{Defines the style of the edge in different states, such as hover, selected,
disabled, etc. Should be a list mapping state names to style configurations.
Default: NULL.}

\item{palette}{Defines the color palette of the edge, used to map colors based on different data.
Default: NULL.}

\item{animation}{Defines the animation effect of the edge. Can be created with
\code{animation_config()}.
Default: NULL.}
}
\value{
A list containing edge options configuration that can be passed to \code{\link[=g6_options]{g6_options()}}.
}
\description{
Configures the general options for edges in a G6 graph. These settings control
the type, style, state, palette, and animation of edges.
}
\details{
Edge options allow defining how edges appear and behave in a G6 graph. This includes
selecting edge types, setting styles, configuring state-based appearances, defining
color palettes, and specifying animation effects.
}
\examples{
# Basic edge options with default line type
options <- edge_options()

# Curved edge with custom style
options <- edge_options(
  type = "cubic",
  style = edge_style_options(
    stroke = "#1783FF",
    lineWidth = 2,
    endArrow = TRUE
  )
)
}
