% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chill_portions.R
\name{chill_portions}
\alias{chill_portions}
\title{Calculation of chill portions from hourly temperature data (Dynamic model)}
\usage{
chill_portions(climdata, Start)
}
\arguments{
\item{climdata}{a dataframe with hourly temperature data. It
must contain the columns Year, Month, Day, DOY, Temp.}

\item{Start}{parameter indicating the day of the year when chill
accumulation is supposed to start.}
}
\value{
dataframe with the chill accumulated for all the seasons in the
dataset. Seasons begin at the start date and end the day before the start
date of the following year.
It contains the columns Year, Month, Day, DOY, Chill
}
\description{
The function calculates chill portions according to the Dynamic model
proposed by Fishman et al. (1987a,b), using the formulas extracted by
Luedeling et al (2009) from functions produced by Erez and Fishman (1990), 
available at the University of California, Agriculture and Natural Resources
(UC ANR) website http://ucanr.edu/sites/fruittree/files/49319.xls. To date, 
chill portions is the best existing model for most growing regions, so chill
fulfilment should  be calculated preferably using this method, especially
when transferring varieties from one region to another, or in studies on 
climate change.
}
\examples{

# Generate hourly temperatures
library(tidyverse)
library(lubridate)
Tudela_HT <- hourly_temps(Tudela_DW,42.13132)
# Calculate chill as chill portions, starting on DOY 305
Chill_p <- chill_portions(Tudela_HT,305)

}
\references{
Erez A, Fishman S, Linsley-Noakes GC and Allan P, 1990. The dynamic model for
rest completion in peach buds. Acta Horticulturae 276, 165-174.

Fishman S, Erez A and Couvillon GA, 1987a. The temperature dependence of
dormancy breaking in plants - computer simulation of processes studied under
controlled temperatures. Journal of Theoretical Biology 126, 309-321.

Fishman S, Erez A and Couvillon GA, 1987b. The temperature dependence of
dormancy breaking in plants - mathematical analysis of a two-step model
involving a cooperative transition. Journal of Theoretical Biology 124,
473-483.

Luedeling E, Zhang M, Luedeling V and Girvetz EH, 2009. Sensitivity of
winter chill models for fruit and nut trees to climatic changes expected in
California's Central Valley. Agriculture, Ecosystems and Environment 133,
23-31.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
