#' @title 
#' Inventory data of an eucalyptus forest in Brazil
#' @description 
#' In this data, each observation is a tree.
#' @usage 
#' data(exfm21)
#' 
#' @format
#' A data frame with 900 observations and 13 variables:
#' \describe{
#'   \item{STRATA}{stratum number}
#'   \item{STRATA_AREA}{area of each strata, in hectares}
#'   \item{PLOT}{plot number}
#'   \item{PLOT_AREA}{area of plots, in square meters}
#'   \item{DBH}{diameter at breast height, in meters}
#'   \item{TH}{total height, in meters}
#'   \item{OBS}{quality of trees, N = normal tree, D = dominant tree, F = a failure, or dead tree}
#'   \item{DH}{dominant height, in meters}
#'   \item{TH_EST}{estimated total height, in meters}
#'   \item{CSA}{cross sectional area, in square meters}
#'   \item{AGE}{average age of plots, in months}
#'   \item{VWB}{volume with bark, in cubic meters}
#'   \item{VWOB}{volume without bark, in cubic meters}
#' }
#' @name exfm21
#' @docType data
#' @author Sollano Rabelo Braga \email{sollanorb@@gmail.com}
#' @keywords data
NULL