% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_multi.R
\name{resid.fixest_multi}
\alias{resid.fixest_multi}
\alias{residuals.fixest_multi}
\title{Extracts the residuals from a \code{fixest_multi} object}
\usage{
\method{resid}{fixest_multi}(
  object,
  type = c("response", "deviance", "pearson", "working"),
  na.rm = FALSE,
  ...
)

\method{residuals}{fixest_multi}(
  object,
  type = c("response", "deviance", "pearson", "working"),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{fixes_multi} object.}

\item{type}{A character scalar, either \code{"response"} (default), \code{"deviance"},
\code{"pearson"}, or \code{"working"}. Note that the \code{"working"} corresponds to the residuals
from the weighted least square and only applies to \code{\link{feglm}} models.}

\item{na.rm}{Logical, default is \code{FALSE}. Should the NAs be kept? If \code{TRUE}, they are removed.}

\item{...}{Not currently used.}
}
\value{
If all the models return residuals of the same length, a matrix is returned. Otherwise,
a \code{list} is returned.
}
\description{
Utility to extract the residuals from multiple \code{fixest} estimations. If possible,
all the residuals are coerced into a matrix.
}
\examples{

base = iris
names(base) = c("y", "x1", "x2", "x3", "species")

# A multiple estimation
est = feols(y ~ x1 + csw0(x2, x3), base)

# We can get all the residuals at once,
# each column is a model
head(resid(est))

# We can select/order the model using fixest_multi extraction
head(resid(est[rhs = .N:1]))

}
