% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-aov.R
\name{get_scores_aov}
\alias{get_scores_aov}
\title{Compute F-statistic and p-value scores using ANOVA F-test}
\usage{
get_scores_aov(score_obj, data, outcome)
}
\arguments{
\item{score_obj}{A score object. See \code{\link[=score_aov]{score_aov()}} for details.}

\item{data}{A data frame or tibble containing the outcome and predictor variables.}

\item{outcome}{A character string specifying the name of the outcome variable.}
}
\value{
A tibble of result with one row per predictor, and four columns:
\itemize{
\item \code{name}: the name of scoring metric.
\item \code{score}: the score for the predictor-outcome pair.
\item \code{predictor}: the name of the predictor.
\item \code{outcome}: the name of the outcome.
}
}
\description{
Evaluate the relationship between a numeric outcome and a categorical predictor,
or vice versa, by computing the ANOVA F-statistic or p-value.
Output a tibble result with with one row per predictor, and four columns:
\code{name}, \code{score}, \code{predictor}, and \code{outcome}.
}
\details{
The \code{score_obj} object may include the following components:
\describe{
\item{\code{neg_log10}}{A logical value indicating whether to apply a negative log10
transformation to p-values (default is \code{TRUE}).
\itemize{
\item If \code{TRUE}, p-values are transformed as \code{-log10(pval)}. In this case:
\itemize{
\item The default \code{fallback_value} is \code{Inf}
\item The default \code{direction} is \code{"maximize"}
}
\item If \code{FALSE}, raw p-values are used. In this case:
\itemize{
\item The \code{fallback_value} should be set to \code{0}
\item The \code{direction} should be set to \code{"minimize"}
}
}
}
}
}
\examples{
data(ames, package = "modeldata")
data <- modeldata::ames |>
  dplyr::select(
    Sale_Price,
    MS_SubClass,
    MS_Zoning,
    Lot_Frontage,
    Lot_Area,
    Street
  )
# Define outcome
outcome <- "Sale_Price"
# Create a score object
score_obj <- score_aov()
score_res <- get_scores_aov(score_obj, data, outcome)
score_res
# Change score type
score_obj$score_type <- "pval"
score_res <- get_scores_aov(score_obj, data, outcome)
score_res
# Use raw p-values instead of -log10(p-values)
score_obj$score_type <- "pval"
score_obj$neg_log10 <- FALSE
score_obj$direction <- "minimize"
score_obj$fallback_value <- 0
score_res <- get_scores_aov(score_obj, data, outcome)
score_res
}
