% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_sql_connect.R
\name{fabric_sql_connect}
\alias{fabric_sql_connect}
\title{Connect to a Microsoft Fabric SQL endpoint}
\usage{
fabric_sql_connect(
  server,
  database = "Lakehouse",
  tenant_id = Sys.getenv("FABRICQUERYR_TENANT_ID"),
  client_id = Sys.getenv("FABRICQUERYR_CLIENT_ID", unset =
    "04b07795-8ddb-461a-bbee-02f9e1bf7b46"),
  access_token = NULL,
  odbc_driver = getOption("fabricqueryr.sql.driver", "ODBC Driver 18 for SQL Server"),
  port = 1433L,
  encrypt = "yes",
  trust_server_certificate = "no",
  timeout = 30L,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{server}{Character. Microsoft Fabric SQL connection string or \code{Server=...} string
(see details).}

\item{database}{Character. Database name. Defaults to \code{"Lakehouse"}.}

\item{tenant_id}{Character. Entra ID (AAD) tenant GUID. Defaults to
\code{Sys.getenv("FABRICQUERYR_TENANT_ID")}.}

\item{client_id}{Character. App registration (client) ID. Defaults to
\code{Sys.getenv("FABRICQUERYR_CLIENT_ID")}, falling back to the Azure CLI app id
\code{"04b07795-8ddb-461a-bbee-02f9e1bf7b46"} if unset.}

\item{access_token}{Optional character. If supplied, use this bearer token
instead of acquiring a new one via \code{{AzureAuth}}.}

\item{odbc_driver}{Character. ODBC driver name. Defaults to
\code{getOption("fabricqueryr.sql.driver", "ODBC Driver 18 for SQL Server")}.}

\item{port}{Integer. TCP port (default 1433).}

\item{encrypt, trust_server_certificate}{Character flags passed to ODBC.
Defaults \code{"yes"} and \code{"no"}, respectively.}

\item{timeout}{Integer. Login/connect timeout in seconds. Default 30.}

\item{verbose}{Logical. Emit progress via \code{{cli}}. Default \code{TRUE}.}

\item{...}{Additional arguments forwarded to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}
}
\value{
A live \code{DBIConnection} object.
}
\description{
Opens a DBI/ODBC connection to a Microsoft Fabric \strong{Data Warehouse} or
\strong{Lakehouse SQL endpoint}, authenticating with Azure AD (MSAL v2)
and passing an access token to the ODBC driver.
}
\details{
\itemize{
\item \code{server} is the Microsoft Fabric SQL connection string, e.g.
\code{"xxxx.datawarehouse.fabric.microsoft.com"}.
You can find this by going to your \strong{Lakehouse} or \strong{Data Warehouse} item,
then \strong{Settings} -> \strong{SQL analytics endpoint} -> \strong{SQL connection string}.
You may also pass a DSN-less \code{Server=...} string; it will be normalized.
\item By default we request a token for
\verb{https://database.windows.net/.default}.
\item \pkg{AzureAuth} is used to acquire the token. Be wary of
caching behavior; you may want to call \code{\link[AzureAuth:get_azure_token]{AzureAuth::clean_token_directory()}}
to clear cached tokens if you run into issues
}
}
\examples{
# Example is not executed since it requires configured credentials for Fabric
\dontrun{
con <- fabric_sql_connect(
  server    = "2gxz...qiy.datawarehouse.fabric.microsoft.com",
  database  = "Lakehouse",
  tenant_id = Sys.getenv("FABRICQUERYR_TENANT_ID"),
  client_id = Sys.getenv("FABRICQUERYR_CLIENT_ID")
)

# List databases
DBI::dbGetQuery(con, "SELECT name FROM sys.databases")

# List tables
DBI::dbGetQuery(con, "
 SELECT TABLE_SCHEMA, TABLE_NAME
 FROM INFORMATION_SCHEMA.TABLES
 WHERE TABLE_TYPE = 'BASE TABLE'
")

# Get a table
df <- DBI::dbReadTable(con, "Customers")
dplyr::glimpse(df)

DBI::dbDisconnect(con)
}
}
