% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histwidth.R
\name{histwidth}
\alias{histwidth}
\alias{width_breaks}
\alias{dhistwidth}
\title{Histogram Widths}
\usage{
histwidth(from, to, widths, dmax = 100)

width_breaks(from, to, widths, dmax = 100)

dhistwidth(from, to, widths, dmax = 100)
}
\arguments{
\item{from}{numeric: start value}

\item{to}{numeric: end value}

\item{widths}{numeric: a vector of width to sample from}

\item{dmax}{numeric: max. denominator value}
}
\value{
A list with \code{breaks}, \code{n}'s for each class and \code{decimal} if all densities are terminating decimals.
}
\description{
Creates a set of breaks and absolute frequencies in the range from '\code{from}' to '\code{to}'. The class widths are
sampled from \code{widths}. The resulting numbers could be multiplied with an integer, if the \code{sum(n)} is too small.
Additionally, it is checked whether the generated densities are terminating decimals.
}
\examples{
l <- histwidth(1.6, 2.1, widths=c(0.05, 0.1, 0.15, 0.2))
l
x <- histx(l$breaks, l$n)
histdata(x, l$breaks)
}
