% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_eurostat_toc.R
\name{get_eurostat_toc}
\alias{getEurostatTOC}
\alias{get_eurostat_toc}
\title{Download a table of contents of eurostat datasets.}
\usage{
get_eurostat_toc()

getEurostatTOC()
}
\value{
A data.frame with eight columns
     \item{title}{The name of dataset of theme}
     \item{code}{The codename of dataset of theme, will be used by the eurostat and get_eurostat_raw functions.}
     \item{type}{Is it a dataset, folder or table.}
     \item{last.update.of.data, last.table.structure.change, data.start, data.end}{Dates.}
}
\description{
Download table of contents (TOC) of eurostat datasets.
             Note that the values in column 'code' should be used
		to download a selected dataset.
}
\details{
The TOC is downloaded from \url{http://ec.europa.eu/eurostat/estat-navtree-portlet-prod/BulkDownloadListing?sort=1&file=table_of_contents_en.txt}
}
\section{Functions}{
\itemize{
\item \code{getEurostatTOC}: Old depricated version
}}
\examples{
\dontrun{tmp <- get_eurostat_toc(); head(tmp)}
}
\author{
Przemyslaw Biecek and Leo Lahti \email{ropengov-forum@googlegroups.com}
}
\references{
See citation("eurostat").
}
\seealso{
\code{\link{get_eurostat}}, \code{\link{search_eurostat}}.
}
\keyword{database}
\keyword{utilities}

