% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{epub_cat}
\alias{epub_cat}
\title{Pretty printing of EPUB text}
\usage{
epub_cat(x, max_paragraphs = 10, skip = 0, paragraph_spacing = 1,
  paragraph_indent = 2, section_sep = "====",
  book_sep = "====\\n====")
}
\arguments{
\item{x}{a data frame returned by \code{\link{epub}} or a character string giving the EPUB filename(s).}

\item{max_paragraphs}{integer, maximum number of paragraphs (non-empty lines) to \code{cat} to console.}

\item{skip}{integer, number of paragraphs to skip.}

\item{paragraph_spacing}{integer, number of empty lines between paragraphs.}

\item{paragraph_indent}{integer, number of spaces to indent paragraphs.}

\item{section_sep}{character, a string to indicate section breaks.}

\item{book_sep}{character, separator shown between books when \code{x} has multiple rows (books).}
}
\value{
nothing is returned but a more readable format of the text content for books in \code{x} is printed to the console.
}
\description{
Print EPUB text to the console in a more readable format.
}
\details{
This function prints text from EPUB files to the console using \code{cat}.
This is useful for quickly obtaining an overview of the book text parsed by \code{\link{epub}} that is easier to read that looking at strings in the table.
\code{max_paragraphs} is set low by default to prevent accidentally printing entire books to the console.
To print everything in \code{x}, set \code{max_paragraphs = NULL}.
}
\examples{
file <- system.file("dracula.epub", package = "epubr")
d <- epub(file)
epub_cat(d, max_paragraphs = 2, skip = 147)
}
\seealso{
\code{\link{epub_head}}
}
