% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgfit.R
\name{residual_process}
\alias{residual_process}
\title{Compute residual process}
\usage{
residual_process(
  component,
  inter_arrival,
  type,
  rambda_component,
  mu,
  beta,
  dimens = NULL,
  mark = NULL,
  N = NULL,
  Nc = NULL,
  lambda_component0 = NULL,
  N0 = NULL,
  ...
)
}
\arguments{
\item{component}{The component of type to get the residual process.}

\item{inter_arrival}{Inter-arrival times of events. This includes inter-arrival for events that occur in all dimensions. Start with zero.}

\item{type}{A vector of types distinguished by numbers, 1, 2, 3, and so on. Start with zero.}

\item{rambda_component}{Right continuous version of lambda process.}

\item{mu}{Numeric value or matrix or function. If numeric, automatically converted to matrix.}

\item{beta}{Numeric value or matrix or function. If numeric, automatically converted to matrix, exponential decay.}

\item{dimens}{Dimension of the model. If omitted, set to be the length of \code{mu}.}

\item{mark}{A vector of realized mark (jump) sizes. Start with zero.}

\item{N}{A matrix of counting processes.}

\item{Nc}{A matrix of counting processes weighted by mark.}

\item{lambda_component0}{The initial values of lambda component. Must have the same dimensional matrix with \code{hspec}.}

\item{N0}{The initial value of N}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
Using random time change, this function compute the residual process, which is the inter-arrival time of a standard Poisson process.
Therefore, the return values should follow the exponential distribution with rate 1, if model and rambda are correctly specified.
}
\examples{

mu <- c(0.1, 0.1)
alpha <- matrix(c(0.2, 0.1, 0.1, 0.2), nrow=2, byrow=TRUE)
beta <- matrix(c(0.9, 0.9, 0.9, 0.9), nrow=2, byrow=TRUE)
h <- new("hspec", mu=mu, alpha=alpha, beta=beta)
res <- hsim(h, size=1000)
rp <- residual_process(component = 1, res$inter_arrival, res$type, res$rambda_component, mu, beta)

}
