% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFreg.R
\name{MFreg}
\alias{MFreg}
\title{Calculate Multifunctionality Regularity (MFreg)}
\usage{
MFreg(data, weights = NULL, cor = FALSE)
}
\arguments{
\item{data}{A data frame or matrix where rows represent observations and columns represent functions.}

\item{weights}{A numeric vector of weights for each function (column in data). If NULL, equal weights are assigned.}

\item{cor}{Logical. If TRUE, function correlations are accounted for using redundancy correction. Default is FALSE.}
}
\value{
A data frame with one column named "MFreg" containing the multifunctionality regularity
values for each observation (row) in the input data.
}
\description{
Calculates the multifunctionality regularity index, which measures how evenly
different ecosystem functions are distributed across the system. The function can
account for correlations between functions when specified.
}
\details{
Multifunctionality Regularity (MFreg) quantifies the evenness of function distribution
in an ecosystem. It is calculated as:

\deqn{MFreg = \frac{-\sum_{i=1}^{n}\frac{w_i f_i}{\sum_{i=1}^{n}w_i f_i}\ln{\frac{w_i f_i}{\sum_{i=1}^{n}w_i f_i}}}{\ln(n)}}
where fi represents the normalized performance level of function i, wi is the weight of function i, and n is the total number of functions examined.

When redundancy correction is applied (`cor = TRUE`), the function accounts for correlations
between ecosystem functions. The correction process involves:

1. Calculating a distance matrix based on correlations: \eqn{d_{ij} = \sqrt{1 - |r_{ij}|}}

2. Applying threshold-based correction: \eqn{d_{ij}(\tau) = \min(d_{ij}, \tau)}

3. Computing effective function values:
   \eqn{F_i(\tau) = \sum_{j=1}^{L}(1 - \frac{d_{ij}(\tau)}{\tau})f_j}

4. Calculating the corrected MFreg using these effective function values:
   \deqn{MFreg = \frac{-\sum_{i=1}^{n}\frac{w_i F_i}{\sum_{i=1}^{n}w_i F_i}\ln{\frac{w_i F_i}{\sum_{i=1}^{n}w_i F_i}}}{\ln(n)}}

5. The final result is the area under the curve (AUC) of MFreg values across different tau thresholds.
}
\examples{
data(forestfunctions)
head(forestfunctions)
MFreg(forestfunctions[,6:31], cor = FALSE)

}
