% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_schoenfeld}
\alias{plot_schoenfeld}
\title{Plot Schoenfeld Residuals}
\usage{
plot_schoenfeld(
  residuals,
  hline = TRUE,
  sline = TRUE,
  sline_se = TRUE,
  hline_col = "#F8766D",
  hline_size = 1,
  hline_alpha = 1,
  hline_yintercept = 0,
  hline_lty = "dashed",
  sline_col = "#00BFC4",
  sline_size = 1,
  sline_alpha = 0.2,
  sline_lty = "dashed",
  point_col = "black",
  point_size = 1,
  point_shape = 19,
  point_alpha = 1,
  plot_theme = ggplot2::theme_bw()
)
}
\arguments{
\item{residuals}{A data frame containing the Schoenfeld residuals, typically
with columns \code{time}, \code{residual}, \code{transform}, and \code{variable}.}

\item{hline}{Logical. If \code{TRUE}, a horizontal line is added to the plot.
Default is \code{TRUE}.}

\item{sline}{Logical. If \code{TRUE}, a smooth line is added to the plot.
Default is \code{TRUE}.}

\item{sline_se}{Logical. If \code{TRUE}, confidence intervals are displayed around
the smooth line. Default is \code{TRUE}.}

\item{hline_col}{Color of the horizontal line. Default is \code{"#F8766D"} (red).}

\item{hline_size}{Line width of the horizontal line. Default is \code{1}.}

\item{hline_alpha}{Transparency of the horizontal line. Default is \code{1}.}

\item{hline_yintercept}{Y-intercept for the horizontal line. Default is \code{0}.}

\item{hline_lty}{Line type for the horizontal line. Default is \code{"dashed"}.}

\item{sline_col}{Color of the smooth line. Default is \code{"#00BFC4"} (blue).}

\item{sline_size}{Line width of the smooth line. Default is \code{1}.}

\item{sline_alpha}{Transparency of the smooth line. Default is \code{0.2}.}

\item{sline_lty}{Line type for the smooth line. Default is \code{"dashed"}.}

\item{point_col}{Color of the points representing residuals. Default is
\code{"black"}.}

\item{point_size}{Size of the points representing residuals. Default is \code{1}.}

\item{point_shape}{Shape of the points representing residuals. Default is
\code{19}.}

\item{point_alpha}{Transparency of the points representing residuals. Default
is \code{1}.}

\item{plot_theme}{A ggplot2 theme for the plot. Default is
\code{\link[ggplot2:ggtheme]{ggplot2::theme_bw()}}.}
}
\value{
A ggplot object representing the plot of Schoenfeld residuals.
}
\description{
Plot the residuals generated by the \code{get_schoenfeld} function.
This function creates a visual representation of Schoenfeld residuals from a
Cox proportional hazards model.
It allows for customization of the plot, including the addition of horizontal
and smoothed lines, and styling of points and plot elements.
}
\examples{
library(survival)
test_fit <- survival::coxph(survival::Surv(time, status) ~ sex, data = lung)
test_fit_zph <- survival::cox.zph(test_fit)
plot_schoenfeld(get_schoenfeld(test_fit_zph))
}
