% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_miniature.R
\name{to_miniature}
\alias{to_miniature}
\title{Thumbnail of a document}
\usage{
to_miniature(
  filename,
  row = NULL,
  width = NULL,
  border_color = "#ccc",
  border_geometry = "2x2",
  dpi = 150,
  fileout = NULL,
  timeout = 120,
  ...
)
}
\arguments{
\item{filename}{input filename, supported documents are 'Microsoft Word',
'Microsoft PowerPoint', 'RTF' and 'PDF' document.}

\item{row}{row index for every pages. 0 are to be used to drop
the page from the final minature.
\itemize{
\item \code{c(1, 1)} is to be used to specify that a 2 pages document
is to be displayed in a single row with two columns.
\item \code{c(1, 1, 2, 3, 3)} is to be used to specify that a 5 pages document
is to be displayed as: first row with pages 1 and 2, second row with page 3,
third row with pages 4 and 5.
\item \code{c(1, 1, 0, 2, 2)} is to be used to specify that a 5 pages document
is to be displayed as: first row with pages 1 and 2,
second row with pages 4 and 5.
}}

\item{width}{width of a single image, recommanded values are:
\itemize{
\item 650 for docx files
\item 750 for pptx files
}}

\item{border_color}{border color, see \code{\link[=image_border]{image_border()}}.}

\item{border_geometry}{border geometry to be added around
images, see \code{\link[=image_border]{image_border()}}.}

\item{dpi}{resolution (dots per inch) to use for images, see \code{\link[=pdf_convert]{pdf_convert()}}.}

\item{fileout}{if not NULL, result is saved in a png file whose filename
is defined by this argument.}

\item{timeout}{timeout in seconds that libreoffice is allowed to use
in order to generate the corresponding pdf file, ignored if 0.}

\item{...}{arguments used by webshot2 when HTML document.}
}
\value{
a magick image object as returned by \code{\link[=image_read]{image_read()}}.
}
\description{
Convert a file into an image (magick image) where the
pages are arranged in rows, each row can contain one to several pages.

The result can be saved as a png file.
}
\examples{
library(locatexec)
docx_file <- system.file(
  package = "doconv",
  "doc-examples/example.docx"
)
if(exec_available("word"))
  to_miniature(docx_file)

pptx_file <- system.file(
  package = "doconv",
  "doc-examples/example.pptx"
)
if(exec_available("libreoffice") && check_libreoffice_export())
  to_miniature(pptx_file)
}
