% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convex_function.R
\name{convex_analysis_of_variables}
\alias{convex_analysis_of_variables}
\title{Analyze a set of variables using convex hulls.}
\usage{
convex_analysis_of_variables(
  data,
  variable_columns,
  batch_col = "batch",
  sample_order_col = "order",
  impute_if_needed = c("median", "mean"),
  mode = c("global", "batchwise")
)
}
\arguments{
\item{data}{Data frame containing the data of multiple variable on multiple
ordered and potentially batched sample.}

\item{variable_columns}{Character vector of variable column names to analyse.}

\item{batch_col}{Name of the column containing batch information.}

\item{sample_order_col}{Name of the column containing the sample time order.}

\item{impute_if_needed}{Method for imputing missing values, either "mean" or
"median".}

\item{mode}{Analysis mode, either "global" or "batchwise"}
}
\value{
A list containing the following elements:
\itemize{
\item data: List of data frames for each variable.
\item indicators: Data frame with convex hull indicators for each variable.
\item convex_hulls: List of data frames of convex hulls for each varaible.
}
}
\description{
Analyze a set of variables using convex hulls.
}
\examples{
# Example usage on toy metabolomics data:
data <- data.frame(
  batch = rep(c("A","B","C"), each = 10),
  injectionOrder = rep(1:30, times = 1),
  metabolite1 = rnorm(30, mean = 100, sd = 10),
  metabolite2 = rnorm(30, mean = 200, sd = 20)
)
result <- convex_analysis_of_variables(
  data = data,
  variable_columns = c("metabolite1", "metabolite2"),
  batch_col = "batch",
  sample_order_col = "injectionOrder",
  impute_if_needed = "median",
  mode = "global"
)
plot_all_convex_hulls(
  target_file_path = file.path(tempdir(), "convex_hulls.pdf"),
  convex_analysis_res = result,
  show_points = TRUE,
  mode = "global"
)
}
