% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/tools.R
\docType{methods}
\name{cdt}
\alias{cdt}
\alias{cdt-method}
\alias{cdt,matrix-method}
\alias{cdt,data.frame-method}
\title{Complete Disjunctive Table}
\usage{
cdt(object, ...)

\S4method{cdt}{matrix}(object, exclude = NULL, abbrev = TRUE)

\S4method{cdt}{data.frame}(object, exclude = NULL, abbrev = TRUE)
}
\arguments{
\item{object}{A \code{\link{data.frame}}.}

\item{...}{Currently not used.}

\item{exclude}{A \code{vector} of values to be excluded when forming the set of
levels (see \code{\link[=factor]{factor()}}). If \code{NULL} (the default), will make \code{NA} an extra
level.}

\item{abbrev}{A \code{\link{logical}} scalar: should the column names be abbreviated?
If \code{FALSE}, these are of the form 'factor_level' but if \code{abbrev = TRUE} they
are just 'level' which will suffice if the factors have distinct levels.}
}
\value{
A \code{\link{data.frame}}.
}
\description{
Computes the complete disjunctive table of a factor table.
}
\examples{
## Create a factor table
x <- data.frame(
  A = c("a", "b", "a"),
  B = c("x", "y", "z")
)

## Complete disjunctive table
cdt(x)

## Burt table
burt(x)
}
\seealso{
Other tools: 
\code{\link{burt}()}
}
\author{
N. Frerebeau
}
\concept{tools}
