% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barriers.R
\name{barriers}
\alias{barriers}
\alias{cashdicall}
\alias{callupin}
\alias{callupout}
\alias{putupin}
\alias{putupout}
\alias{calldownin}
\alias{calldownout}
\alias{putdownin}
\alias{putdownout}
\alias{uicall}
\alias{uocall}
\alias{dicall}
\alias{docall}
\alias{uiput}
\alias{uoput}
\alias{diput}
\alias{doput}
\alias{cashuicall}
\alias{cashuiput}
\alias{cashdiput}
\alias{assetuicall}
\alias{assetuiput}
\alias{assetdicall}
\alias{assetdiput}
\alias{cashuocall}
\alias{cashuoput}
\alias{cashdocall}
\alias{cashdoput}
\alias{assetuocall}
\alias{assetuoput}
\alias{assetdocall}
\alias{assetdoput}
\alias{dr}
\alias{ur}
\alias{drdeferred}
\alias{urdeferred}
\title{Barrier option pricing}
\usage{
callupin(s, k, v, r, tt, d, H)
callupout(s, k, v, r, tt, d, H)
putupin(s, k, v, r, tt, d, H)
putupout(s, k, v, r, tt, d, H)
calldownin(s, k, v, r, tt, d, H)
calldownout(s, k, v, r, tt, d, H)
putdownin(s, k, v, r, tt, d, H)
putdownout(s, k, v, r, tt, d, H)
uicall(s, k, v, r, tt, d, H) ## same as callupin
uocall(s, k, v, r, tt, d, H) ## same as callupout
uiput(s, k, v, r, tt, d, H)  ## same as putupin
uoput(s, k, v, r, tt, d, H)  ## same as putupout
dicall(s, k, v, r, tt, d, H) ## same as calldownin
docall(s, k, v, r, tt, d, H) ## same as calldownout
diput(s, k, v, r, tt, d, H)  ## same as putdownin
doput(s, k, v, r, tt, d, H)  ## same as putdownout
cashuicall(s, k, v, r, tt, d, H)
cashuiput(s, k, v, r, tt, d, H)
cashdicall(s, k, v, r, tt, d, H)
cashdiput(s, k, v, r, tt, d, H)
assetuicall(s, k, v, r, tt, d, H)
assetuiput(s, k, v, r, tt, d, H)
assetdicall(s, k, v, r, tt, d, H)
assetdiput(s, k, v, r, tt, d, H)
cashuocall(s, k, v, r, tt, d, H)
cashuoput(s, k, v, r, tt, d, H)
cashdocall(s, k, v, r, tt, d, H)
cashdoput(s, k, v, r, tt, d, H)
assetuocall(s, k, v, r, tt, d, H)
assetuoput(s, k, v, r, tt, d, H)
assetdocall(s, k, v, r, tt, d, H)
assetdoput(s, k, v, r, tt, d, H)
dr(s, v, r, tt, d, H, perpetual)
ur(s, v, r, tt, d, H, perpetual)
drdeferred(s, v, r, tt, d, H)
urdeferred(s, v, r, tt, d, H)
}
\arguments{
\item{s}{Stock price}

\item{k}{Strike price of the option}

\item{v}{Volatility of the stock, defined as the annualized
standard deviation of the continuously-compounded return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{H}{Barrier}

\item{perpetual}{Boolean for the case where an up or down rebate is
infinitely lived. Default is FALSE.}
}
\value{
The pricing functions return the price of a barrier
claim. If more than one argument is a vector, the recycling rule
determines the handling of the inputs.
}
\description{
This library provides a set of barrier binary options
that are used to construct prices of barrier options. The
nomenclature is that

\itemize{
\item "call" and "put" refer to claims that are exercised when the
asset price is above or below the strike;

\item "up" and "down" refer to claims for which the barrier is above or
below the current asset price; and

\item "in" and "out" refer to claims that knock in or out
}

For example, for standard barrier options, \code{calldownin} refers
to a knock-in call for which the barrier is below the current
price, while \code{putdownout} refers to a knock-out put for which
the barrier is below the current asset price.

For binary barrier options, "ui", "di" "uo", and "do" refer to
up-and-in, down-and-in, up-and-out, and down-and-out options.

Rebate options pay \$1 if a barrier is reached. The barrier can be
reached from above ("d") or below ("d"), and the payment can occur
immediately ("ur" or "dr") or at expiration ("drdeferred" and
"urdeferred")

\code{callupin(s, k, v, r, tt, d, H) =  
assetuicall(s, k, v, r, tt, d, H) - k*cashuicall(s, k, v, r, tt, d, H)
}
}
\details{
Returns a scalar or vector  of option prices, depending on
the inputs
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0; H=44
callupin(s, k, v, r, tt, d, H)

## following returns the same price as previous
assetuicall(s, k, v, r, tt, d, H) - k*cashuicall(s, k, v, r, tt, d, H)

## return option prices for different strikes putupin(s, k=38:42,
#v, r, tt, d, H)
}
\concept{Barriers}
