\name{plotbary}
\alias{plotbary}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{
Makes a barycenter plot of a level set tree, a location plot of a
shape tree, or a tail tree plot of a tail tree
}
\description{
Plots a barycenter plot of a level set tree,
or a location plot of a shape tree (of the given direction),
or a tail tree plot of tail tree (of the given direction).
A barycenter plot visualizes the barycenters of the separated
regions of the level sets of the function.
The barycenter of a set is the "center of mass" of this set.
A location plot visualizes the barycenters of the tail regions of a set.
A tail tree plot makes a parallel level plot of the data, and shows
the tree structure of the tail tree in the plot.
}
\usage{
plotbary(lst, coordi=1, 
plot=TRUE, data=FALSE, crit=NULL,orderrule="distcenter",
modelabel=FALSE, ptext=0, leimat=NULL, symbo=NULL, 
info=NULL, infolift=0, infopos=0,
xmarginleft=0, xmarginright=0, ymargin=0, 
xlim=NULL, ylim=NULL, xaxt="s", yaxt="s", 
nodesymbo=20, col=NULL, col.axis="black", collines=NULL, paletti=NULL,
shift=0, shiftindex=NULL,
modlabret=FALSE, modecolo=NULL, modepointer=NULL, colometh = "lst", 
colothre = min(lst$level), lines=TRUE, wedge=FALSE, lty.wedge=2, title=TRUE,
titletext="coordinate", cex=NULL, nodemag=NULL, cex.sub=1, cex.axis = 1, 
newtitle = FALSE, cex.lab = 1)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{lst}{level set tree or shape tree; list of vectors.
   The list contains at least vectors "level", "volume", and "parent". 
   For example, function "leafsfirst" gives a level set tree or a shape tree
   as an output. 
   Functions "profkern" and "profhist" give a level 
   set tree as an output.
  }
  \item{coordi}{integer 1,...,d, when the function is d-dimensional; 
   gives the coordinate direction
   with respect which the plot will be made.}
  \item{plot}{T or F; TRUE if we make a plot, otherwise FALSE.}
  \item{data}{T or F; TRUE if we want the output to contain some
   information, for example the ordering for siblings. 
   This option is needed only by  other plotting
   functions of the package, it is not needed by the end user.}
  \item{crit}{d-vector of real numbers; gives a way to control
   an ordering of siblings. The leftmost sibling is the one whose
   barycenter is furthest away from vector "crit", in the Euclidean metric.}
  \item{orderrule}{lower level parameter}
  \item{modelabel}{T or F; TRUE if the modes will be labelled.
   The default is to use labels M1, M2,...}
  \item{ptext}{non-negative real number; amount by which the mode
   labels will be lifted.}
  \item{leimat}{vector of characters; the length of the vector should be
   equal to the number of modes of the estimate.
   This option is for the case we do not want the ordering of the
   labels to be done automatically.}
  \item{symbo}{character; for example "L". The default value for the
   automatic labelling of the modes is to use M1, M2,...
   With "symbo" we may switch to L1, L2,..., for example.}
  \item{info}{vector of numbers or characters, whose length is equal
   to the number of nodes of the level set tree.
   The elements of "info" will be placed on the right side of the 
   nodes. For example "info" may be generated by "excmas" or we may define
   "info" to contain the frequencies of the nodes.
   (Frequencies may be obtained directly from the function "profhist")}
  \item{infolift}{real number; controls the vertical positioning of
   the elements of "info".}
  \item{infopos}{real number; controls the horizontal positioning of
   the elements of "info". Negative "infopos" will move elements of
   "info" to the right hand side.}
  \item{xmarginleft}{non-negative real number; adds more margin on the 
   left hand side. The box around the plot will be moved to the left
   with the amount "xmarginleft".}
  \item{xmarginright}{non-negative real number; adds more margin on the 
   right hand side. The box around the plot will be moved to the right
   with the amount "xmarginright".}
  \item{ymargin}{nonnegative real number; adds more margin on the 
   top of the plot. The box around plot will be moved up
   with the amount "ymargin".}
  \item{xlim}{vector of 2 real numbers; gives the limits for the scale
   of x-axis.}
  \item{ylim}{vector of 2 real numbers; gives the limits for the scale
   of y-axis.}
  \item{xaxt}{a character which specifies the x axis type; either "s" or "n";
   see "par"}
  \item{yaxt}{a character which specifies the y axis type; either "s" or "n";
   see "par"}
  \item{nodesymbo}{symbol for the nodes of the tree; integer 19-25; 
   see help(points) for the definitions}
  \item{col}{colour for the nodes; for example "black" or "blue".}
  \item{col.axis}{colour for the x and y-axis; for example "black" or
  "blue".}
  \item{collines}{colour for lines joining nodes; 
   for example "black" or "blue".}
  \item{paletti}{a character vector of color names, in the order they will be
   used to color the nodes and the lines connecting the nodes; coloring starts
   from the leafs nodes and the color is changed always when two branches 
   are joining}
  \item{shift}{a real number; the amount to shift a label of a leaf node;
   used to enhance the plot, see the parameter "shiftindex"}
  \item{shiftindex}{the index to be shifted, see the parameter "shift"}
  \item{modlabret}{T or F; T if the locations of the modes will be returned}
  \item{modecolo}{lowel level parameter}
  \item{modepointer}{lowel level parameter}
  \item{colometh}{if colometh=="lst", then colors are first chosen for 
   the leafs, otherwise the colors are first chosen for the roots;
   for the level set trees it is better to choose "lst", but for dendrograms it
   is better to color the roots first}
  \item{colothre}{positive real number; fixes the colors at the level given by
  "colothre", this option is used for dendrograms}
  \item{lines}{TRUE or FALSE; used in a tail tree plot; FALSE suppresses the 
   parent-child lines and one can avoid over plotting}
  \item{wedge}{TRUE or FALSE; used in a tail tree plot if TRUE, then the 
   outer limts for the points will be plotted; these outer limits have a
   wedge form}
  \item{lty.wedge}{"lty" parameter (line type) for the wedge lines}
  \item{title}{if TRUE, then the subtitle "coordinate i" is printed
   when the coordinate is i and the the titletext is "coordinate"}
  \item{titletext}{character string; the text in the title will be titletext i,
   if the barycenter plot is for the i:th coordinate}
  \item{cex}{magnification factor for the symbols; see "par" }
  \item{nodemag}{magnification factor for the the points }
  \item{cex.sub}{magnification factor for the subtitle; see "par" }
  \item{cex.axis}{the magnification to be used for axis annotation; see "par"}
  \item{newtitle}{FALSE or TRUE; if TITLE=FALSE, we can put newtitle=TRUE
   to print the title as an x-axis annotation, and not as a subtitle}
  \item{cex.lab}{the magnification to be used for x and y labels; see "par"}
}
\value{
  By default a plot is made on the graphics window. 
  If modlabret=T, then the locations of the modes are returned,
  with the labeling of the modes corresponding to the labeling in the plot. 
}

%\references{http://www.rni.helsinki.fi/~jsk/denpro}
\author{ Jussi Klemela }
%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{ 
\code{\link{leafsfirst}},
\code{\link{treedisc}},
\code{\link{prunemodes}},
\code{\link{plotvolu}}, 
\code{\link{plottree}}
}

\examples{
# level set tree

dendat<-sim.data(n=100,type="mulmod")
pcf<-pcf.kern(dendat,h=1,N=c(32,32))
lst<-leafsfirst(pcf)             
td<-treedisc(lst,pcf,ngrid=30)

plotbary(td)

plotbary(td,coordi=2,ptext=0.002,symbo="L",modlabret=TRUE)

# shape tree

dendat<-sim.data(n=100,type="cross")
pcf<-pcf.kern(dendat,h=1,N=c(32,32))
st<-leafsfirst(pcf,propor=0.01)   
td<-treedisc(st,pcf,ngrid=60)

plotbary(td)

# tail tree

tt<-leafsfirst(dendat=dendat,rho=0.65)  
plotbary(tt)

}
\keyword{multivariate}% at least one, from doc/KEYWORDS
\keyword{hplot}% __ONLY ONE__ keyword per line





