% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{write_metadata}
\alias{write_metadata}
\title{Creates define XML metadata}
\usage{
write_metadata(
  dir,
  type = "sdtm",
  ver = NULL,
  src_dir = NULL,
  check = TRUE,
  demo = FALSE
)
}
\arguments{
\item{dir}{The directory in which to produce the metadata.}

\item{type}{The type of metadata file to produce.  Valid values are
"SDTM" and "ADAM". Default is "SDTM".}

\item{ver}{The version of the metadata file.  Default is
the preferred version of the define standard.  The function
currently supports only version "2.0.0".}

\item{src_dir}{If the metadata will be generated from existing datasets,
supply the directory path for those datasets.  If the metadata will
not be created from datasets, this parameter should be NULL.  Datasets
should be in XPT file format.}

\item{check}{Whether or not to run the checks.}

\item{demo}{If this parameter is TRUE, the function will generate
a metadata file populated with sample data. If the parameter is FALSE,
a blank metadata spreadsheet will be produced. Default is FALSE.}
}
\value{
The full path of the generated metadata file.
}
\description{
The function generates define.xml metadata and
writes it to the file system. The function can generate a blank metadata
spreadsheet, a demonstration spreadsheet, or metadata read
from existing data files. The \code{type} parameter can be used
to request an SDTM or ADAM spreadsheet.
}
\details{
Frequently, organizations already have study metadata stored
in Excel spreadsheets, and in the correct structure.  This structure
is used commonly in the industry by other software.

The purpose of the \code{write_metadata} function is to create an
initial metadata template for studies in which you have no metadata.
This task will ensure that you have the proper metadata structure
to later create the define.xml.

By default, the function creates an unpopulated metadata spreadsheet.
If the \code{demo} parameter is set to TRUE, the function will create
the same spreadsheet populated with sample data.  This sample data
can help you to understand how to populate the metadata for your study.
Note that this demo spreadsheet is populated correctly, and has no
conformance errors.  Use this demo spreadsheet as a guide to fill
out your metadata.

The demo spreadsheet was created by CDISC, and is
included in the \strong{defineR} package for convenience.
}
\examples{
# Get temporary directory
tmp <- tempdir()

# Create demo spreadsheet
out1 <- write_metadata(tmp, demo = TRUE)

# View file
# file.show(out1)

# Create unpopulated spreadsheet
out2 <- write_metadata(tmp, demo = FALSE)

# View file
# file.show(out2)
}
\seealso{
\code{\link{write_define}} to create a define.xml document and
associated files.
}
