% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeploymentServiceStats.R
\name{GetDeploymentServiceStatsOverTime}
\alias{GetDeploymentServiceStatsOverTime}
\title{Retrieves service health statistics over time on given metrics for a deployment.}
\usage{
GetDeploymentServiceStatsOverTime(
  deploymentId,
  metrics = DeploymentServiceHealthMetric$TotalPredictions,
  modelId = NULL,
  start = NULL,
  end = NULL,
  bucketSize = NULL,
  quantile = NULL,
  threshold = NULL,
  segmentAttribute = NULL,
  segmentValue = NULL
)
}
\arguments{
\item{deploymentId}{character. The ID of the deployment.}

\item{metrics}{character. Optional. Metrics to query. See \code{DeploymentServiceHealthMetric} for
supported values. If not provided, defaults to \code{TotalPredictions}.}

\item{modelId}{character. Optional. The ID of the model to query. If provided, only data for this
specific model will be retrieved; otherwise, data for the deployment's default model will be
retrieved.}

\item{start}{POSIXct. Optional. The start time of the reporting period for monitoring data.
Defaults to seven days prior to the end of the period. Sub-hour resolution is not permitted,
and the timezone must be \code{UTC}.}

\item{end}{POSIXct. Optional. The end time of the reporting period for monitoring data. Defaults
to the next top of the hour. Sub-hour resolution is not permitted, and the timezone must be
\code{UTC}.}

\item{bucketSize}{character. Optional. The time duration of a bucket. This should be a multiple
of one hour and cannot be longer than the total length of the period. If not set, a default
value will be calculated based on the \code{start} and \code{end} times.}

\item{quantile}{numeric. Optional. Quantile for the \code{executionTime} and \code{responseTime} metrics.
Defaults to 0.5.}

\item{threshold}{integer. Optional. Threshold for the \code{slowQueries} metric. Defaults to 1000.}

\item{segmentAttribute}{character. Optional. The name of an attribute used for segment analysis.
See \code{SegmentAnalysisAttribute} for permitted values. Added in DataRobot 2.20.}

\item{segmentValue}{character. Optional. The value of \code{segmentAttribute}. Added in DataRobot
2.20.}
}
\value{
\itemize{
\item modelId character. The ID of the deployment model for which monitoring data was
retrieved.
\item summary data.frame. Summarizes statistics for each metric over the entire reporting
period.
\item buckets data.frame. Statistics for each metric, split into intervals of equal duration.
There is one column representing stats for each metric queried, as well as:
\itemize{
\item start POSIXct. Start of the interval.
\item end POSIXct. End of the interval.
}
\item segmentAttribute character. Added in DataRobot 2.20. The name of the segment on which
segment analysis was performed.
\item segmentValue character. Added in DataRobot 2.20. The value of \code{segmentAttribute}.
}
}
\description{
By default this will return statistics for the last seven days prior to the next; set the \code{start}
and \code{end} parameters to adjust the reporting period.
}
\examples{
\dontrun{
metrics <- c(DeploymentServiceHealthMetric)
GetDeploymentServiceStatsOverTime(deploymentId, metrics = metrics)
}
}
