% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata_samples.R
\name{read_waterdata_samples}
\alias{read_waterdata_samples}
\alias{read_USGS_samples}
\title{USGS Samples Data}
\usage{
read_waterdata_samples(
  monitoringLocationIdentifier = NA,
  siteTypeCode = NA,
  boundingBox = NA,
  hydrologicUnit = NA,
  activityMediaName = NA,
  characteristicGroup = NA,
  characteristic = NA,
  characteristicUserSupplied = NA,
  activityStartDateLower = NA,
  activityStartDateUpper = NA,
  countryFips = NA,
  stateFips = NA,
  countyFips = NA,
  projectIdentifier = NA,
  recordIdentifierUserSupplied = NA,
  siteTypeName = NA,
  usgsPCode = NA,
  pointLocationLatitude = NA,
  pointLocationLongitude = NA,
  pointLocationWithinMiles = NA,
  dataType = "results",
  dataProfile = NA,
  tz = "UTC",
  convertType = TRUE
)

read_USGS_samples(
  monitoringLocationIdentifier = NA,
  siteTypeCode = NA,
  boundingBox = NA,
  hydrologicUnit = NA,
  activityMediaName = NA,
  characteristicGroup = NA,
  characteristic = NA,
  characteristicUserSupplied = NA,
  activityStartDateLower = NA,
  activityStartDateUpper = NA,
  countryFips = NA,
  stateFips = NA,
  countyFips = NA,
  projectIdentifier = NA,
  recordIdentifierUserSupplied = NA,
  siteTypeName = NA,
  usgsPCode = NA,
  pointLocationLatitude = NA,
  pointLocationLongitude = NA,
  pointLocationWithinMiles = NA,
  dataType = "results",
  dataProfile = NA,
  tz = "UTC",
  convertType = TRUE
)
}
\arguments{
\item{monitoringLocationIdentifier}{A monitoring location identifier has two parts: the agency code
and the location number, separated by a dash (-). Location identifiers should be separated with commas,
for example: AZ014-320821110580701, CAX01-15304600, USGS-040851385. Location
numbers without an agency prefix are assumed to have the prefix USGS.}

\item{siteTypeCode}{Site type code query parameter. See available
options by running \code{check_waterdata_sample_params("sitetype")$typeCode}.}

\item{boundingBox}{North and South are latitude values; East and West are longitude values.
A vector of 4 (west, south, east, north) is expected.
An example would be: c(-92.8, 44.2, -88.9, 46.0).}

\item{hydrologicUnit}{Hydrologic Unit Codes (HUCs) identify physical areas
within the US that drain to a certain portion of the stream network.
This filter accepts values containing 2, 4, 6, 8, 10 or 12 digits.}

\item{activityMediaName}{Sample media refers to the environmental medium that
was sampled or analyzed.}

\item{characteristicGroup}{Characteristic group is a broad category describing the sample.
See available options by running
\code{check_waterdata_sample_params("characteristicgroup")$characteristicGroup}.}

\item{characteristic}{Characteristic is a specific category describing the sample.
See available options by running
\code{check_waterdata_sample_params("characteristics")$characteristicName}.}

\item{characteristicUserSupplied}{Observed property is the USGS term for the
constituent sampled and the property name gives a detailed description of what
was sampled. Observed property is mapped to characteristicUserSupplied and replaces
the parameter name and pcode USGS
previously used to describe discrete sample data. Find more information in the
Observed Properties and Parameter Codes section of the Code Dictionary found here:
\url{https://waterdata.usgs.gov/code-dictionary/}.}

\item{activityStartDateLower}{The service will return records with dates earlier
than the value entered for activityStartDateUpper. Can be an R Date object, or
a string with format YYYY-MM-DD. The logic is inclusive, i.e. it will also return
records that match the date.}

\item{activityStartDateUpper}{The service will return records with dates later
than the value entered for activityStartDateLower. Can be an R Date object, or
a string with format YYYY-MM-DD. The logic is inclusive, i.e. it will also return
records that match the date.}

\item{countryFips}{Country query parameter. Do not set redundant parameters.
If another query parameter contains the country information, leave this parameter
set to the default NA. See available options by running \code{check_waterdata_sample_params("countries")},
where the "id" field contains the value to use in the countryFips input.}

\item{stateFips}{State query parameter. To get a list of available state fips,
run \code{check_waterdata_sample_params("states")}. The "fips" can be created using the function
\code{stateCdLookup} - for example: \code{stateCdLookup("WI", "fips")}.
FIPs codes for states take the format:
CountryAbbrev:StateNumber, like US:55 for Wisconsin.}

\item{countyFips}{County query parameter. To get a list of available counties,
run \code{check_waterdata_sample_params("counties")}. The "Fips" can be created using the function
\code{countyCdLookup} - for example: \code{countyCdLookup("WI", "Dane", "fips")}
for Dane County, WI.
FIPs codes for counties take the format:
CountryAbbrev:StateNumber:CountyNumber, like US:55:025 for Dane County, WI.}

\item{projectIdentifier}{Project identifier query parameter. This information
would be needed from prior project information.}

\item{recordIdentifierUserSupplied}{Record identifier, user supplied identifier. This
information would be needed from the data supplier.}

\item{siteTypeName}{Site type name query parameter. See available
options by running \code{check_param("sitetype")$typeName}.}

\item{usgsPCode}{USGS parameter code. See available options by running
\code{check_waterdata_sample_params("characteristics")$parameterCode}.}

\item{pointLocationLatitude}{Latitude for a point/radius query (decimal degrees). Must be used
with pointLocationLongitude and pointLocationWithinMiles.}

\item{pointLocationLongitude}{Longitude for a point/radius query (decimal degrees). Must be used
with pointLocationLatitude and pointLocationWithinMiles.}

\item{pointLocationWithinMiles}{Radius for a point/radius query. Must be used
with pointLocationLatitude and pointLocationLongitude}

\item{dataType}{Options include: "Results", "Monitoring locations", "Activities",
"Projects", and "Organizations".}

\item{dataProfile}{Profile depends on type. Options for "results" dataType are:
"fullphyschem", "basicphyschem", "fullbio", "basicbio", "narrow",
"resultdetectionquantitationlimit", "labsampleprep", "count". Options for "locations" are:
"site" and "count". Options for "activities" are "sampact", "actmetric", "actgroup",
and "count". Options for "projects" are:
"project" and "projectmonitoringlocationweight". Options for "organizations" are:
"organization" and "count".}

\item{tz}{character to set timezone attribute of datetime. Default is UTC
(properly accounting for daylight savings times based on the data's provided tz_cd column).
Possible values include "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua",
"America/Phoenix", and "America/Metlakatla"}

\item{convertType}{logical, defaults to \code{TRUE}. If \code{TRUE}, the function
will convert the data to dates, datetimes,
numerics based on a standard algorithm. If false, everything is returned as a character.}
}
\description{
This function creates the call and gets the data for discrete water quality samples data
service described at \url{https://waterdata.usgs.gov/download-samples/}.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{
ph_data <- read_waterdata_samples(
               monitoringLocationIdentifier = "USGS-04074950",
               characteristicUserSupplied = "pH, water, unfiltered, field",
               activityStartDateUpper = "2000-01-01",
               dataProfile = "narrow")
               
nameToUse <- "pH"
pHData <- read_waterdata_samples(monitoringLocationIdentifier = "USGS-04024315", 
                         characteristic = nameToUse)
ncol(pHData)
attr(pHData, "url")
attr(pHData, "queryTime")

summary_data <- read_waterdata_samples(monitoringLocationIdentifier = "USGS-04024315", 
                               dataType = "projects")

}
\dontshow{\}) # examplesIf}
}
