\name{finiteDLMauto}
\alias{finiteDLMauto}

\title{
Find the optimal lag length for finite DLMs
}
\description{
A function that fits finite DLMs for a range of lag lengths and orders the fitted models according to a desired measure.
}
\usage{
finiteDLMauto(formula , data, x, y, q.min = 1, q.max = 10, k.order = NULL, 
model.type = c("dlm","poly"), error.type = c("MASE","AIC","BIC","radj"), trace = FALSE)
}
\arguments{
  \item{formula}{A \code{formula} object for the model to be fitted. In the case of multiple predictor series, the model should be entered via a formula object.
  }
  \item{data}{  A \code{data.frame} including all dependent and independent series. In the case of multiple predictor series, the data should be entered via the \code{data} argument.
  }
  \item{x}{
  A vector including the observations of predictor time series. This is not restricted to \code{ts} objects.
  }
  \item{y}{
  A vector including the observations of dependent time series. This is not restricted to \code{ts} objects.
  }
  \item{q.min}{
  An integer representing the lower limit of the range of lag lengths to be considered. If missing, it will be set to 1.
  }
  \item{q.max}{
  An integer representing the upper limit of the range of lag lengths to be considered. If missing, it will be set to 10.
  }
  \item{k.order}{
  An integer representing order of polynomial distributed lags.
  }
  \item{model.type}{
  The type of model to be fitted. If set to \code{dlm}, finite distributed lag models are fitted. If set to \code{poly}, polynomial distributed lag models are fitted. 
  }
  \item{error.type}{
  The type of goodness-of-fit measure to be used for the selection of optimal lag length. If set to \code{MASE}, the optimal lag length is determined according to MASE. If set to \code{AIC}, the optimal lag length is determined according to AIC. If set to \code{BIC}, the optimal lag length is determined according to BIC. If set to \code{radj}, the optimal lag length is determined according to Adjusted R-square.
  }
  \item{trace}{
  If \code{TRUE}, prints all of the goodness-of-fit measures for all fitted models.
  }  
 
}
\details{
When there is only one predictor series, both of \code{model} and \code{formula} objects can be used. But when they are supplied, both \code{x} and \code{y} arguments should be \code{NULL}.

The variable names in \code{formula} must match with the names of variables in \code{data} argument and it must be in the form of a generic formula for R functions. 

The argument \code{data} contains dependent series and independent series. Required lags of dependent series are generated by the \code{dlm} function automatically. 

If \code{q.max} is entered greater than 20, its value will be adjusted to have a sample size of 20 for fitting the regression model for finite DLMs.
}

\value{
Returns a \code{data.frame} including the values of goodness-of-fit measures and corresponding lag lengths.
}


\author{
Agung Andiojaya <agung.andiojaya@gmail.com>, Haydar Demirhan 

Maintainer: Haydar Demirhan <haydar.demirhan@rmit.edu.au>
}

\examples{
# Only one independent series
data(warming)
# Run the search over polynomial DLMs according to MASE values
finiteDLMauto(x = warming$NoMotorVehicles , y = warming$Warming ,
q.max = 12, k.order = 3, model.type = "poly",
error.type = "MASE", trace = TRUE)

# Run the search over finite DLMs according to AIC values
finiteDLMauto(x = warming$NoMotorVehicles , y = warming$Warming , 
q.min = 2, q.max = 12, model.type = "dlm", error.type = "AIC", 
trace = TRUE)

# Multiple independent series
data(M1Germany)
data = M1Germany[1:144,]
# Run the search over finite DLMs according to AIC values
finiteDLMauto(formula = logprice ~ interest + logm1, 
        data = data.frame(data), q.min = 2, q.max = 8, 
        model.type = "dlm", error.type = "AIC", trace = TRUE)
}
