% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-datasets.R
\name{listDatasets}
\alias{listDatasets}
\title{Get the names of datasets in a project}
\usage{
listDatasets(
  kind = c("active", "all", "archived"),
  project = NULL,
  refresh = FALSE,
  shiny = FALSE
)
}
\arguments{
\item{kind}{character specifying whether to look in active, archived, or all
datasets. Default is "active", i.e. non-archived.}

\item{project}{\code{ProjectFolder} entity, character name of a project, or
\code{NULL}, the default. If a Project entity or reference is supplied, the
function will display datasets from that Project's datasets. If \code{NULL},
your personal folder will be used.}

\item{refresh}{logical: should the function check the Crunch API for new
datasets? Default is FALSE.}

\item{shiny}{deprecated, no longer works}
}
\value{
A character vector of dataset names, each of which would be a valid
input for \code{\link[=loadDataset]{loadDataset()}}
}
\description{
\code{listDatasets()} is a convenience function for quickly seeing what datasets
are in a project. It is equivalent to \code{names(datasets(proj))}, with some
additional optional arguments.
}
