% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmate.R
\name{check_length}
\alias{check_length}
\alias{assert_length}
\alias{test_length}
\title{Check if vectors are of compatible lengths}
\usage{
check_length(x, len)

assert_length(x, len, .var.name = checkmate::vname(x), add = NULL)

test_length(x, len)
}
\arguments{
\item{x}{(\code{any})\cr the first vector, any object for which \code{\link[=length]{length()}}
function is defined.}

\item{len}{(\code{count})\cr the length of the second vector.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link[checkmate]{AssertCollection}}.}
}
\value{
\code{TRUE} if successful, otherwise a string with the error message.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Two vectors are of compatible size if and only if: \cr
\enumerate{
\item At least one vector has size 1 \cr
\item or both vectors are of the same size. \cr
}
}
\examples{
check_length(1:5, 1)
check_length(1:5, 6)
check_length(1:5, 5)
check_length(10, 1)
check_length(10, 9)
}
\seealso{
\code{\link{assertions}} for more details.
}
