% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hype.R
\name{R6_hype}
\alias{R6_hype}
\title{Hyperparameter optimization}
\description{
Hyperparameter optimization

Hyperparameter optimization
}
\examples{

# Have df output, but only use one value from it
h1 <- hype(
  eval_func = function(a, b) {data.frame(c=a^2+b^2, d=1:2)},
  extract_output_func = function(odf) {odf$c[1]},
  a = par_unif('a', -1, 2),
  b = par_unif('b', -10, 10),
  n_lhs = 10
)
h1$run_all()
h1$add_EI(n = 1)
h1$run_all()
#system.time(h1$run_EI_for_time(sec=3, batch_size = 1))
#system.time(h1$run_EI_for_time(sec=3, batch_size = 3))
h1$plotorder()
h1$plotX()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{X}}{Data frame of inputs that have been evaluated or will be evaluated
next.}

\item{\code{Z}}{Output at X}

\item{\code{runtime}}{The time it took to evaluate each row of X}

\item{\code{parnames}}{Names of the parameters}

\item{\code{parlowerraw}}{Lower bounds for each parameter on raw scale}

\item{\code{parupperraw}}{Upper bounds for each parameter on raw scale}

\item{\code{parlowertrans}}{Lower bounds for each parameter on transformed scale}

\item{\code{paruppertrans}}{Upper bounds for each parameter on transformed scale}

\item{\code{parlist}}{List of all parameters}

\item{\code{modlist}}{A list with details about the model. The user shouldn't
ever edit this directly.}

\item{\code{ffexp}}{An ffexp R6 object used to run the experiment and store
the results.}

\item{\code{eval_func}}{The function we evaluate.}

\item{\code{extract_output_func}}{A function that takes in the output from
`eval_func` and returns the value we are trying to minimize.}

\item{\code{par_all_cts}}{Are all the parameters continuous?}

\item{\code{verbose}}{How much should be printed? 0 is none, 1 is standard,
2 is more, 5+ is a lot}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{mod}}{Gaussian process model used to predict what the output will be.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-hype-new}{\code{R6_hype$new()}}
\item \href{#method-hype-add_data}{\code{R6_hype$add_data()}}
\item \href{#method-hype-add_X}{\code{R6_hype$add_X()}}
\item \href{#method-hype-add_LHS}{\code{R6_hype$add_LHS()}}
\item \href{#method-hype-convert_trans_to_raw}{\code{R6_hype$convert_trans_to_raw()}}
\item \href{#method-hype-convert_raw_to_trans}{\code{R6_hype$convert_raw_to_trans()}}
\item \href{#method-hype-change_par_bounds}{\code{R6_hype$change_par_bounds()}}
\item \href{#method-hype-add_EI}{\code{R6_hype$add_EI()}}
\item \href{#method-hype-fit_mod}{\code{R6_hype$fit_mod()}}
\item \href{#method-hype-run_all}{\code{R6_hype$run_all()}}
\item \href{#method-hype-run_EI_for_time}{\code{R6_hype$run_EI_for_time()}}
\item \href{#method-hype-plot}{\code{R6_hype$plot()}}
\item \href{#method-hype-pairs}{\code{R6_hype$pairs()}}
\item \href{#method-hype-plotorder}{\code{R6_hype$plotorder()}}
\item \href{#method-hype-plotX}{\code{R6_hype$plotX()}}
\item \href{#method-hype-plotXorder}{\code{R6_hype$plotXorder()}}
\item \href{#method-hype-plotinteractions}{\code{R6_hype$plotinteractions()}}
\item \href{#method-hype-print}{\code{R6_hype$print()}}
\item \href{#method-hype-best_params}{\code{R6_hype$best_params()}}
\item \href{#method-hype-update_mod_userspeclist}{\code{R6_hype$update_mod_userspeclist()}}
\item \href{#method-hype-clone}{\code{R6_hype$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-new"></a>}}
\if{latex}{\out{\hypertarget{method-hype-new}{}}}
\subsection{Method \code{new()}}{
Create hype R6 object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$new(
  eval_func,
  ...,
  X0 = NULL,
  Z0 = NULL,
  n_lhs,
  extract_output_func,
  verbose = 1,
  model = "GauPro",
  covtype = "matern5_2",
  nugget.estim = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{eval_func}}{The function used to evaluate new points.}

\item{\code{...}}{Hyperparameters to optimize over.}

\item{\code{X0}}{Data frame of initial points to run, or points already
evaluated. If already evaluated, give in outputs in "Z0"}

\item{\code{Z0}}{Evaluated outputs at "X0".}

\item{\code{n_lhs}}{The number that should initially be run using
a maximin Latin hypercube.}

\item{\code{extract_output_func}}{A function that takes in the output from
`eval_func` and returns the value we are trying to minimize.}

\item{\code{verbose}}{How much should be printed? 0 is none, 1 is standard,
2 is more, 5+ is a lot}

\item{\code{model}}{What package to fit the Gaussian process model with.
Either "GauPro" or "DiceKriging"/"DK".}

\item{\code{covtype}}{Covariance/correlation/kernel function for the GP model.}

\item{\code{nugget.estim}}{Should the nugget be estimated when fitting
the GP model?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-add_data"></a>}}
\if{latex}{\out{\hypertarget{method-hype-add_data}{}}}
\subsection{Method \code{add_data()}}{
Add data to the experiment results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$add_data(X, Z)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Data frame with names matching the input parameters}

\item{\code{Z}}{Output at rows of X matching the experiment output.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-add_X"></a>}}
\if{latex}{\out{\hypertarget{method-hype-add_X}{}}}
\subsection{Method \code{add_X()}}{
Add new inputs to run. This allows the user to specify
what they want run next.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$add_X(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{Data frame with names matching the input parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-add_LHS"></a>}}
\if{latex}{\out{\hypertarget{method-hype-add_LHS}{}}}
\subsection{Method \code{add_LHS()}}{
Add new input points using a maximin
Latin hypercube.
Latin hypercubes are usually more spacing than randomly picking points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$add_LHS(n, just_return_df = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of points to add.}

\item{\code{just_return_df}}{Instead of adding to experiment, should
it just return the new set of values?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-convert_trans_to_raw"></a>}}
\if{latex}{\out{\hypertarget{method-hype-convert_trans_to_raw}{}}}
\subsection{Method \code{convert_trans_to_raw()}}{
Convert parameters from transformed scale to raw scale.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$convert_trans_to_raw(Xtrans)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Xtrans}}{Parameters on the transformed scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-convert_raw_to_trans"></a>}}
\if{latex}{\out{\hypertarget{method-hype-convert_raw_to_trans}{}}}
\subsection{Method \code{convert_raw_to_trans()}}{
Convert parameters from raw scale to transformed scale.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$convert_raw_to_trans(Xraw)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Xraw}}{Parameters on the raw scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-change_par_bounds"></a>}}
\if{latex}{\out{\hypertarget{method-hype-change_par_bounds}{}}}
\subsection{Method \code{change_par_bounds()}}{
Change lower/upper bounds of a parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$change_par_bounds(parname, lower, upper)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parname}}{Name of the parameter}

\item{\code{lower}}{New lower bound. Leave empty if not changing.}

\item{\code{upper}}{New upper bound. Leave empty if not changing.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-add_EI"></a>}}
\if{latex}{\out{\hypertarget{method-hype-add_EI}{}}}
\subsection{Method \code{add_EI()}}{
Add new inputs to run using the expected information
criteria
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$add_EI(
  n,
  covtype = NULL,
  nugget.estim = NULL,
  model = NULL,
  eps,
  just_return = FALSE,
  calculate_at
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of points to add.}

\item{\code{covtype}}{Covariance function to use for the Gaussian process
model.}

\item{\code{nugget.estim}}{Should a nugget be estimated?}

\item{\code{model}}{Which package should be used to fit the model and
calculate the EI? Use "DK" for DiceKriging or "GauPro" for GauPro.}

\item{\code{eps}}{Exploration parameter. The minimum amount of improvement
you care about.}

\item{\code{just_return}}{Just return the EI info, don't actually add the
points to the design.}

\item{\code{calculate_at}}{Calculate the EI at a specific point.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-fit_mod"></a>}}
\if{latex}{\out{\hypertarget{method-hype-fit_mod}{}}}
\subsection{Method \code{fit_mod()}}{
Fit model to the data collected so far
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$fit_mod(covtype = NULL, nugget.estim = NULL, model = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{covtype}}{Covariance function to use for the Gaussian process
model.}

\item{\code{nugget.estim}}{Should a nugget be estimated?}

\item{\code{model}}{Which package should be used to fit the model and
calculate the EI? Use "DK" for DiceKriging or "GauPro" for GauPro.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-run_all"></a>}}
\if{latex}{\out{\hypertarget{method-hype-run_all}{}}}
\subsection{Method \code{run_all()}}{
Run all unevaluated input points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$run_all(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Passed into `ffexp$run_all`. Can set 'parallel=TRUE'
to evaluate multiple points simultaneously as long as all needed
variables have been passed to 'varlist'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-run_EI_for_time"></a>}}
\if{latex}{\out{\hypertarget{method-hype-run_EI_for_time}{}}}
\subsection{Method \code{run_EI_for_time()}}{
Add points using the expected information criteria,
evaluate them, and repeat until a specified amount of time has passed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$run_EI_for_time(
  sec,
  batch_size,
  covtype = "matern5_2",
  nugget.estim = TRUE,
  verbose = 0,
  model = "GauPro",
  eps = 0,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sec}}{Number of seconds to run for. It will go over this time
limit, finish the current iteration, then stop.}

\item{\code{batch_size}}{Number of points to run at once.}

\item{\code{covtype}}{Covariance function to use for the Gaussian process
model.}

\item{\code{nugget.estim}}{Should a nugget be estimated?}

\item{\code{verbose}}{Verbose parameter to pass to ffexp$}

\item{\code{model}}{Which package should be used to fit the model and
calculate the EI? Use "DK" for DiceKriging or "GauPro" for GauPro.}

\item{\code{eps}}{Exploration parameter. The minimum amount of improvement
you care about.}

\item{\code{...}}{Passed into `ffexp$run_all`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-plot"></a>}}
\if{latex}{\out{\hypertarget{method-hype-plot}{}}}
\subsection{Method \code{plot()}}{
Make a plot to summarize the experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-pairs"></a>}}
\if{latex}{\out{\hypertarget{method-hype-pairs}{}}}
\subsection{Method \code{pairs()}}{
Plot pairs of inputs and output
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$pairs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-plotorder"></a>}}
\if{latex}{\out{\hypertarget{method-hype-plotorder}{}}}
\subsection{Method \code{plotorder()}}{
Plot the output of the points evaluated in order.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$plotorder()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-plotX"></a>}}
\if{latex}{\out{\hypertarget{method-hype-plotX}{}}}
\subsection{Method \code{plotX()}}{
Plot the output as a function of each input.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$plotX(
  addlines = TRUE,
  addEIlines = TRUE,
  covtype = NULL,
  nugget.estim = NULL,
  model = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{addlines}}{Should prediction mean and 95\% interval be plotted?}

\item{\code{addEIlines}}{Should expected improvement lines be plotted?}

\item{\code{covtype}}{Covariance function to use for the Gaussian process
model.}

\item{\code{nugget.estim}}{Should a nugget be estimated?}

\item{\code{model}}{Which package should be used to fit the model and
calculate the EI? Use "DK" for DiceKriging or "GauPro" for GauPro.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-plotXorder"></a>}}
\if{latex}{\out{\hypertarget{method-hype-plotXorder}{}}}
\subsection{Method \code{plotXorder()}}{
Plot each input in the order they were chosen.
Colored by quality.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$plotXorder()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-plotinteractions"></a>}}
\if{latex}{\out{\hypertarget{method-hype-plotinteractions}{}}}
\subsection{Method \code{plotinteractions()}}{
Plot the 2D plots from inputs to the output.
All other variables are held at their values for the best input.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$plotinteractions(covtype = "matern5_2", nugget.estim = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{covtype}}{Covariance function to use for the Gaussian process
model.}

\item{\code{nugget.estim}}{Should a nugget be estimated?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-print"></a>}}
\if{latex}{\out{\hypertarget{method-hype-print}{}}}
\subsection{Method \code{print()}}{
Print details of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{not used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-best_params"></a>}}
\if{latex}{\out{\hypertarget{method-hype-best_params}{}}}
\subsection{Method \code{best_params()}}{
Returns the best parameters
evaluated so far.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$best_params()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-update_mod_userspeclist"></a>}}
\if{latex}{\out{\hypertarget{method-hype-update_mod_userspeclist}{}}}
\subsection{Method \code{update_mod_userspeclist()}}{
Updates the specifications for the GP model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$update_mod_userspeclist(
  model = NULL,
  covtype = NULL,
  nugget.estim = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{What package to fit the Gaussian process model with.
Either "GauPro" or "DiceKriging"/"DK".}

\item{\code{covtype}}{Covariance/correlation/kernel function for the GP model.}

\item{\code{nugget.estim}}{Should the nugget be estimated when fitting
the GP model?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hype-clone"></a>}}
\if{latex}{\out{\hypertarget{method-hype-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_hype$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
