% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{cocoSim}
\alias{cocoSim}
\title{Marginal and conditional simulation of nonstationary Gaussian processes}
\usage{
cocoSim(coco.object, pars, n, seed, standardize, 
type = 'classic', sim.type = NULL, cond.info = NULL)
}
\arguments{
\item{coco.object}{(\code{S4}) A \link{coco} object.}

\item{pars}{(\code{numeric vector} or NULL) A vector of parameter values associated with \code{model.list}.
If coco.object is a fitted object, and pars is \code{NULL}, it get pars from coco.object\@output$pars (and also sets 'type' to 'diff').}

\item{n}{(\code{integer}) Number of realizations to simulate.}

\item{seed}{(\code{integer or NULL}) Seed for random number generation. Defaults to NULL.}

\item{standardize}{(\code{logical}) Indicates whether the provided covariates should be standardized (\code{TRUE}) or not (\code{FALSE}). Defaults to \code{TRUE}.}

\item{type}{(\code{character}) Specifies whether the parameters follow a classical parameterization (\code{'classic'}) or a difference parameterization (\code{'diff'}). Defaults to \code{'classic'}. For sparse \code{coco} objects, only \code{'diff'} is allowed.}

\item{sim.type}{(\code{character}) If set to \code{'cond'}, a conditional simulation is performed.}

\item{cond.info}{(\code{list}) A list containing additional information required for conditional simulation.}
}
\value{
(\code{matrix}) a matrix dim(data)[1] x n.
}
\description{
draw realizations of stationary and nonstationary Gaussian processes with covariate-based covariance functions.
}
\details{
#' The argument \code{sim.type = 'cond'} specifies a conditional simulation, requiring \code{cond.info} to be provided.
\code{cond.info} is a list including \code{newdataset}, a data.frame containing covariates present in \code{model.list} at the simulation locations, and \code{newlocs},
a matrix specifying the locations corresponding to the simulation, with indexing that matches \code{newdataset}.

The argument \code{type = 'classic'} assumes a simplified parameterization for the covariance function, with log-parameterizations applied to the parameters \code{std.dev},
\code{scale}, and \code{smooth}.
}
\examples{
\dontrun{

model.list <- list('mean' = 0,
                   'std.dev' = formula( ~ 1 + cov_x + cov_y),
                   'scale' = formula( ~ 1 + cov_x + cov_y),
                   'aniso' = 0,
                   'tilt' = 0,
                   'smooth' = 0.5,
                   'nugget' = -Inf)
                   
coco_object <- coco(type = 'dense',
                    data = holes[[1]][1:1000,],
                    locs = as.matrix(holes[[1]][1:1000,1:2]),
                    z = holes[[1]][1:1000,]$z,
                    model.list = model.list)
                    
coco_sim <- cocoSim(coco.object = coco_object,
            pars = c(0,0.25,0.25,  # pars related to std.dev
            log(0.25),1,-1),       # pars related to scale
            n = 1, 
            standardize = TRUE) 

fields::quilt.plot(coco_object@locs,coco_sim)             
}

}
\seealso{
\link{coco}
}
\author{
Federico Blasi
}
