% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsaf.transform.coordinate.system.R
\name{cmsaf.transform.coordinate.system}
\alias{cmsaf.transform.coordinate.system}
\title{Transform the coordinate system to -180 to 180 longitude of an infile}
\usage{
cmsaf.transform.coordinate.system(infile, var, outfile, nc = NULL)
}
\arguments{
\item{infile}{Filename of input NetCDF file. This may include the directory
(character).}

\item{var}{Name of NetCDF variable (character).}

\item{outfile}{Filename of output NetCDF file. This may include the directory
(character).}

\item{nc}{Alternatively to \code{infile} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\value{
A NetCDF file including the coordinate system (-180 to 180 longitude) is
written.
}
\description{
Transform the coordinate system to -180 to 180 longitude of an infile
}
\seealso{
Other data manipulation functions: 
\code{\link{acsaf_box_mergetime}()},
\code{\link{add_grid_info}()},
\code{\link{box_mergetime}()},
\code{\link{levbox_mergetime}()},
\code{\link{map_regular}()},
\code{\link{remap}()}
}
\concept{data manipulation functions}
