% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclic_chart.R
\name{cyclic_chart}
\alias{cyclic_chart}
\title{Plot Cyclic Data (General Format)}
\usage{
cyclic_chart(df, Period, Value, crit, ColV)
}
\arguments{
\item{df}{A data frame}

\item{Period}{A list of periodical values such as hours of the day, days of
the week, months of the year and so on.}

\item{Value}{A numeric vector with the values corresponding to the \code{Period}}

\item{crit}{A factor variable based on which the bars would be colored.}

\item{ColV}{A character vector with the list of colors for the bars.
You can use this online tool (\url{https://r-charts.com/color-palette-generator/})
to create a beautiful color palette.}
}
\value{
A \code{ggplot} object, which can be further modified
with \code{ggplot2} functions and themes.
}
\description{
This function plots values corresponding to random periods such as hours,
days, months and so on.
}
\details{
This can plot values corresponding to multiple categories, for example,
temperature in different cities on the days of a week, or rainfall by month
in a year.
}
\examples{
# Using package built-in bdtemp data
Col <- c("#0040ff", "#00bfff", "#8000ff")
cyclic_chart(bdtemp,
  Period = Month, Value = Temperature,
  crit = City, ColV = Col
)
}
\seealso{
\code{\link[=day_chart]{day_chart()}} for plotting values on a day by hours,
\code{\link[=week_chart]{week_chart()}} for plotting values in a week by days,
\code{\link[=year_chart]{year_chart()}} for plotting values in a year by months
}
