% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_num.r
\name{extract_num}
\alias{extract_num}
\title{Extract numbers from string.}
\usage{
extract_num(
  x,
  res_type = c("first", "range"),
  multimatch2na = FALSE,
  leq_1 = FALSE,
  allow_neg = TRUE,
  zero_regexp = NULL,
  max_regexp = NULL,
  max_quantile = 0.95
)
}
\arguments{
\item{x}{A character vector.}

\item{res_type}{The type of the result. Can be \code{"first"} or \code{"range"}. If \code{"first"}, the first number in the string
is extracted. If \code{"range"}, the mean of the range in the string is extracted.}

\item{multimatch2na}{If \code{TRUE}, multiple matches will be converted to \code{NA}. Only works when \code{res_type} is \code{"first"}.}

\item{leq_1}{If \code{TRUE}, numbers greater than 1 will be converted to \code{NA}. Only works when \code{res_type} is \code{"first"}.}

\item{allow_neg}{If \code{TRUE}, negative numbers are allowed. Otherwise, only positive numbers are allowed.}

\item{zero_regexp}{A regular expression to match the string that indicates zero.}

\item{max_regexp}{A regular expression to match the string that indicates the maximum value.}

\item{max_quantile}{The quantile of values to set the maximum value to.}
}
\value{
A numeric vector.
}
\description{
Extract numerical values from strings. Can be used to filter out the unwanted information
coming along with the numbers.
}
\details{
The function uses regular expressions to extract numbers from strings. The regular expression used is
\code{"-?[0-9]+\\\\.?[0-9]*|-?\\\\.[0-9]+"}, which matches any number that may have a decimal point and may have a
negative sign.
}
\examples{
x <- c("1.2(XXX)", "5-8POS", "NS", "FULL", "5.5", "4.2")
extract_num(x)
extract_num(x,
  res_type = "first", multimatch2na = TRUE, zero_regexp = "NEG|NS",
  max_regexp = "FULL"
)
extract_num(x, res_type = "range", allow_neg = FALSE, zero_regexp = "NEG|NS", max_regexp = "FULL")
}
