% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg_AR_logit.R
\name{avg_AR_logit}
\alias{avg_AR_logit}
\title{An Average of the Upper Bound on Causal Attributable Risk}
\usage{
avg_AR_logit(
  y,
  t,
  x,
  sampling = "cc",
  p_upper = 1L,
  length = 21L,
  interaction = TRUE,
  eps = 1e-08
)
}
\arguments{
\item{y}{n-dimensional vector of binary outcomes}

\item{t}{n-dimensional vector of binary treatments}

\item{x}{n by d matrix of covariates}

\item{sampling}{'cc' for case-control sampling; 'cp' for case-population sampling; 'rs' for random sampling (default =  'cc')}

\item{p_upper}{specified upper bound for the unknown true case probability (default = 1)}

\item{length}{specified length of a sequence from 0 to p_upper (default = 21)}

\item{interaction}{TRUE if there are interaction terms in the retrospective logistic model; FALSE if not (default = TRUE)}

\item{eps}{a small constant that determines the trimming of the estimated probabilities.
Specifically, the estimate probability is trimmed to be between eps and 1-eps (default = 1e-8).}
}
\value{
An S3 object of type "ciccr". The object has the following elements.
\item{est}{(length)-dimensional vector of the average of the upper bound of causal attributable risk}
\item{pseq}{(length)-dimensional vector of a grid from 0 to p_upper}
}
\description{
Averages the upper bound on causal attributable risk using prospective and retrospective logistic regression models
under the monotone treatment response (MTR) and monotone treatment selection (MTS) assumptions.
}
\examples{
# use the ACS_CC dataset included in the package.
  y = ciccr::ACS_CC$topincome
  t = ciccr::ACS_CC$baplus
  x = ciccr::ACS_CC$age
  results = avg_AR_logit(y, t, x, sampling = 'cc')

}
\references{
Jun, S.J. and Lee, S. (2023). Causal Inference under Outcome-Based Sampling with Monotonicity Assumptions.
\url{https://arxiv.org/abs/2004.08318}.

Manski, C.F. (1997). Monotone Treatment Response.
Econometrica, 65(6), 1311-1334.

Manski, C.F. and Pepper, J.V. (2000). Monotone Instrumental Variables: With an Application to the Returns to Schooling.
Econometrica, 68(4), 997-1010.
}
