% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ces_subset.R
\name{get_ces_subset}
\alias{get_ces_subset}
\title{Get Subset of Variables from Canadian Election Study Dataset}
\usage{
get_ces_subset(
  year,
  variant = NULL,
  variables = NULL,
  regex = FALSE,
  format = "tibble",
  clean = TRUE,
  use_cache = TRUE
)
}
\arguments{
\item{year}{A character string indicating the year of the CES data.}

\item{variant}{A character string indicating the survey variant to download.
Options depend on the year: "single_survey" (default for most years), "web" (default for 2015, 2019),
"phone", "combo", "1974_1980", "jnjl", "sep", "nov". Use \code{\link{list_ces_datasets}} to see
available variants for each year.}

\item{variables}{A character vector of variable names to select from the dataset.
If NULL (default), all variables are returned.}

\item{regex}{A logical indicating whether to use regex matching for variable names.
Default is FALSE.}

\item{format}{A character string indicating the format to return the data in.
Default is "tibble". Options include "tibble", "data.frame", or "raw".}

\item{clean}{Logical indicating whether to clean the data. Default is TRUE.}

\item{use_cache}{Logical indicating whether to use cached data if available.
Default is TRUE.}
}
\value{
A tibble or data.frame containing the requested CES data variables.
}
\description{
This function allows users to get a specific subset of variables from a CES dataset.
It's useful for selecting only the variables of interest for a specific analysis.
}
\examples{
\donttest{
# Get only vote choice and demographic variables from 2019 web survey
variables <- c("vote_choice", "age", "gender", "province", "education")
ces_subset <- get_ces_subset("2019", variables = variables)

# Get subset from 2019 phone survey  
ces_subset_phone <- get_ces_subset("2019", variant = "phone", variables = variables)

# Get all variables containing "vote" in their name (using regex)
vote_vars <- get_ces_subset("2019", variables = "vote", regex = TRUE)
}

}
