% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{TCells}
\alias{TCells}
\title{Two-Photon Data: T Cells in a Lymph Node}
\format{
## `TCells`
An S3 object of class "tracks"; a list with 199 elements. Each 
element name identifies a cell track. Each element is a matrix
containing the following three columns.
\describe{
	\item{\code{t}}{the time (in seconds)}
	\item{\code{x}}{The X coordinate (in micrometers)}
 \item{\code{y}}{The Y coordinate (in micrometers)}
}
}
\source{
Data were generated in 2021 in the Mark J. Miller Lab, Department of Medicine, Washington University in St Louis, USA.
}
\usage{
data("TCells")
}
\description{
RFP-labelled T cells were injected retro-orbitally in healthy CD11c-YFP mice, and 
intravitally imaged (using two-photon microscopy) inside a cervical lymph
node. These data illustrate the characteristic "random-walk-like" motion pattern 
of T cells in lymph nodes. For full method details, see references below.
}
\examples{
  ## load the tracks
  data(TCells)

  ## visualize the tracks (calls function plot.tracks)
  plot(TCells)

}
\references{
Miller MJ and Wei SH and Parker I and Cahalan MD (2002), 
Two-photon imaging of lymphocyte motility and antigen response in intact lymph node.
\emph{Science}, \bold{296}(5574):1869--1873. doi:10.1126/science.1070051

Wortel IMN and Liu AY and Dannenberg K and Berry JC and Miller MJ and Textor J (2021),
CelltrackR: an R package for fast and flexible analysis of immune cell migration data.
\emph{ImmunoInformatics}, \bold{1-2}:100003. doi:10.1016/j.immuno.2021.100003
}
\keyword{datasets}
