% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.R
\name{two_long_clust_diff}
\alias{two_long_clust_diff}
\title{Generate Two Linear Differentiated Clusters with Noise}
\usage{
two_long_clust_diff(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of data points to be generated.}

\item{num_noise}{The number of additional noise dimensions to be generated.}

\item{min_n}{The minimum value for the noise added to the data points.}

\item{max_n}{The maximum value for the noise added to the data points.}
}
\value{
A matrix containing the generated data, with each row representing a data point.
}
\description{
This function generates data with two linear clusters that are differentiated
 from each other, along with added noise.
}
\examples{

# Generate two linear differentiated clusters with noise with custom parameters
set.seed(20240412)
data <- two_long_clust_diff(
  n = 300, num_noise = 2, min_n = -0.05,
  max_n = 0.05
)
}
