% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/electrical_emissions.R
\name{electrical_emissions}
\alias{electrical_emissions}
\title{Calculate Electrical Emissions}
\usage{
electrical_emissions(
  fridges = 0,
  freezers = 0,
  large = 0,
  IT = 0,
  small = 0,
  alkaline_batteries = 0,
  LiIon_batteries = 0,
  NiMh_batteries = 0,
  fridges_WD = 0,
  freezers_WD = 0,
  large_WD = 0,
  IT_WD = 0,
  small_WD = 0,
  alkaline_batteries_WD = 0,
  LiIon_batteries_WD = 0,
  NiMh_batteries_WD = 0,
  waste_disposal = c("Landfill", "Open-loop"),
  units = c("kg", "tonnes")
)
}
\arguments{
\item{fridges}{Numeric value indicating the weight of fridges. Default is \code{0}.}

\item{freezers}{Numeric value indicating the weight of freezers. Default is \code{0}.}

\item{large}{Numeric value indicating the weight of large electrical items. Default is \code{0}.}

\item{IT}{Numeric value indicating the weight of IT (Information Technology) equipment. Default is \code{0}.}

\item{small}{Numeric value indicating the weight of small electrical items. Default is \code{0}.}

\item{alkaline_batteries}{Numeric value indicating the weight of alkaline batteries. Default is \code{0}.}

\item{LiIon_batteries}{Numeric value indicating the weight of Lithium-ion batteries. Default is \code{0}.}

\item{NiMh_batteries}{Numeric value indicating the weight of Nickel Metal Hydride batteries. Default is \code{0}.}

\item{fridges_WD}{Numeric value indicating the weight of fridges disposed of using waste disposal methods. Default is \code{0}.}

\item{freezers_WD}{Numeric value indicating the weight of freezers disposed of using waste disposal methods. Default is \code{0}.}

\item{large_WD}{Numeric value indicating the weight of large electrical items disposed of using waste disposal methods. Default is \code{0}.}

\item{IT_WD}{Numeric value indicating the weight of IT equipment disposed of using waste disposal methods. Default is \code{0}.}

\item{small_WD}{Numeric value indicating the weight of small electrical items disposed of using waste disposal methods. Default is \code{0}.}

\item{alkaline_batteries_WD}{Numeric value indicating the weight of alkaline batteries disposed of using waste disposal methods. Default is \code{0}.}

\item{LiIon_batteries_WD}{Numeric value indicating the weight of Lithium-ion batteries disposed of using waste disposal methods. Default is \code{0}.}

\item{NiMh_batteries_WD}{Numeric value indicating the weight of Nickel Metal Hydride batteries disposed of using waste disposal methods. Default is \code{0}.}

\item{waste_disposal}{Character vector specifying the waste disposal method to use for calculating emissions. Possible values: \code{"Landfill"}, \code{"Open-loop"}. Default is \code{"Landfill"}.
\code{"Open-loop"} is the process of recycling material into other products.
\code{"Landfill"} the product goes to landfill after use.}

\item{units}{Character vector specifying the units of the emissions output. Possible values: \code{"kg"}, \code{"tonnes"}. Default is \code{"kg"}.}
}
\value{
The calculated electrical emissions as a numeric value in tonnes.
}
\description{
This function calculates the emissions produced from different electrical items and their waste disposal based on the specified inputs. It considers emissions from primary material production and waste disposal of electrical items.
}
\examples{
# Calculate electrical emissions using default values
electrical_emissions()

# Calculate electrical emissions with specific quantities and waste disposal
# method
electrical_emissions(fridges = 10, IT = 5, alkaline_batteries = 100,
                     waste_disposal = "Open-loop", units = "tonnes")
}
