% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappaPrior.R
\name{kappaPrior}
\alias{kappaPrior}
\title{Braid kappa Bayesian Prior}
\usage{
kappaPrior(spread, strength = "moderate")
}
\arguments{
\item{spread}{Rough estimate of the standard deviation of measurement noise
or errors expected in a given data set.  Commonly used values are standard
deviation of negative/positive controls or root mean squared error of a
preliminary surface fit.}

\item{strength}{String indicating the influence of the BRAID prior on the
resulting fit.  Must be one of "mild", "moderate" (the default), "high", or
"none".}
}
\value{
An object of class \code{kappaPrior} containing two numeric elements,
\code{spread}, and \code{strength}.  Used in BRAID fitting functions to stabilize
the parameter kappa
}
\description{
Generates a Bayesian prior object on the BRAID parameter kappa to stabilize
parameter fitting
}
\examples{
prior <- kappaPrior(0.05,"mild")

bfit <- braidrm(measure ~ concA + concB, incompleteExample,
                prior=prior, getCIs=FALSE)
summary(bfit)
}
