% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRII.R
\name{drawbeta3}
\alias{drawbeta3}
\title{Samples \eqn{\beta} for an Ordinal Model
with 3 outcomes}
\usage{
drawbeta3(z, x, sigma, nu, tau2, theta, invB0, invB0b0)
}
\arguments{
\item{z}{dependent variable i.e. ordinal outcome values.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{sigma}{scale factor, a scalar value.}

\item{nu}{modified scale factor, row vector.}

\item{tau2}{2/(p(1-p)).}

\item{theta}{(1-2p)/(p(1-p)).}

\item{invB0}{inverse of prior covariance matrix of normal distribution.}

\item{invB0b0}{prior mean pre-multiplied by invB0.}
}
\value{
Returns a column vector of \eqn{\beta}
from a multivariate normal distribution.
}
\description{
This function samples \eqn{\beta} from its conditional
posterior distribution for an ordinal model with 3
outcomes.
}
\details{
Function samples a vector of \eqn{\beta} from a multivariate normal distribution.
}
\examples{
set.seed(101)
z <- c(21.01744, 33.54702, 33.09195, -3.677646,
 21.06553, 1.490476, 0.9618205, -6.743081, 21.02186, 0.6950479)
x <- matrix(c(
     1, -0.3010490, 0.8012506,
     1,  1.2764036, 0.4658184,
     1,  0.6595495, 1.7563655,
     1, -1.5024607, -0.8251381,
     1, -0.9733585, 0.2980610,
     1, -0.2869895, -1.0130274,
     1,  0.3101613, -1.6260663,
     1, -0.7736152, -1.4987616,
     1,  0.9961420, 1.2965952,
     1, -1.1372480, 1.7537353),
     nrow = 10, ncol = 3, byrow = TRUE)
sigma <- 1.809417
nu <- c(5, 5, 5, 5, 5, 5, 5, 5, 5, 5)
tau2 <- 10.6667
theta <- 2.6667
invB0 <- matrix(c(
     1, 0, 0,
     0, 1, 0,
     0, 0, 1),
     nrow = 3, ncol = 3, byrow = TRUE)
invB0b0 <- c(0, 0, 0)

ans <- drawbeta3(z, x, sigma, nu, tau2, theta, invB0, invB0b0)

# ans
#   -0.74441 1.364846 0.7159231

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988).
“The New S Language. Wadsworth & Brooks/Cole.”

Casella, G., George E. I. (1992). “Explaining the Gibbs Sampler."
The American Statistician, 46(3): 167-174.

Geman, S., and Geman, D. (1984). “Stochastic Relaxation,
Gibbs Distributions, and the Bayesian Restoration of Images."
IEEE Transactions an Pattern Analysis and Machine Intelligence,
6(6): 721-741.
}
\seealso{
Gibbs sampling, normal distribution
, \link[GIGrvg]{rgig}
}
