% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_3.R
\docType{class}
\name{BIOMOD.models.out}
\alias{BIOMOD.models.out}
\alias{BIOMOD.models.out-class}
\alias{show,BIOMOD.models.out-method}
\title{\code{BIOMOD_Modeling()} output object class}
\usage{
\S4method{show}{BIOMOD.models.out}(object)
}
\arguments{
\item{object}{a \code{\link{BIOMOD.models.out}} object}
}
\description{
Class returned by \code{\link{BIOMOD_Modeling}}, and used by 
\code{\link{BIOMOD_LoadModels}}, \code{\link{BIOMOD_PresenceOnly}}, 
\code{\link{BIOMOD_Projection}} and \code{\link{BIOMOD_EnsembleModeling}}
}
\section{Slots}{

\describe{
\item{\code{modeling.id}}{a \code{character} corresponding to the name (ID) of the
simulation set}

\item{\code{dir.name}}{a \code{character} corresponding to the modeling folder}

\item{\code{sp.name}}{a \code{character} corresponding to the species name}

\item{\code{expl.var.names}}{a \code{vector} containing names of explanatory
variables}

\item{\code{models.computed}}{a \code{vector} containing names of computed models}

\item{\code{models.failed}}{a \code{vector} containing names of failed models}

\item{\code{has.evaluation.data}}{a \code{logical} value defining whether evaluation
data is given}

\item{\code{scale.models}}{a \code{logical} value defining whether models have been
rescaled or not}

\item{\code{formated.input.data}}{a \code{\link{BIOMOD.stored.formated.data-class}}
object containing informations from \code{\link{BIOMOD_FormatingData}}
object}

\item{\code{calib.lines}}{a \code{\link{BIOMOD.stored.data.frame-class}} object
containing calibration lines}

\item{\code{models.options}}{a \code{\link{BIOMOD.stored.options-class}}
object containing informations from \code{\link{bm_ModelingOptions}}
object}

\item{\code{models.evaluation}}{a \code{\link{BIOMOD.stored.data.frame-class}} object
containing models evaluation}

\item{\code{variables.importance}}{a \code{\link{BIOMOD.stored.data.frame-class}} object
containing variables importance}

\item{\code{models.prediction}}{a \code{\link{BIOMOD.stored.data.frame-class}} object
containing models predictions}

\item{\code{models.prediction.eval}}{a \code{\link{BIOMOD.stored.data.frame-class}}
object containing models predictions for evaluation data}

\item{\code{link}}{a \code{character} containing the file name of the saved object}
}}

\examples{

showClass("BIOMOD.models.out")

## ----------------------------------------------------------------------- #
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

## ----------------------------------------------------------------------- #
# Format Data with true absences
myBiomodData <- BIOMOD_FormatingData(resp.var = myResp,
                                     expl.var = myExpl,
                                     resp.xy = myRespXY,
                                     resp.name = myRespName)

## ----------------------------------------------------------------------- #
# Model single models
myBiomodModelOut <- BIOMOD_Modeling(bm.format = myBiomodData,
                                    modeling.id = 'AllModels',
                                    models = c('RF', 'GLM'),
                                    CV.strategy = 'random',
                                    CV.nb.rep = 2,
                                    CV.perc = 0.8,
                                    OPT.strategy = 'bigboss',
                                    metric.eval = c('TSS','ROC'),
                                    var.import = 3,
                                    seed.val = 42)
myBiomodModelOut


}
\seealso{
\code{\link{BIOMOD_Modeling}}, \code{\link{BIOMOD_LoadModels}}, 
\code{\link{BIOMOD_PresenceOnly}}, \code{\link{BIOMOD_Projection}}, 
\code{\link{BIOMOD_EnsembleModeling}}, \code{\link{bm_VariablesImportance}}, 
\code{\link{bm_PlotEvalMean}}, \code{\link{bm_PlotEvalBoxplot}}, 
\code{\link{bm_PlotVarImpBoxplot}}, \code{\link{bm_PlotResponseCurves}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.formated.data.PA}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.options.dataset}},
\code{\link{BIOMOD.options.default}},
\code{\link{BIOMOD.projection.out}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Damien Georges
}
\concept{Toolbox objects}
