% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_zc.R
\name{plot_zc}
\alias{plot_zc}
\title{Generate spectrogram for Zero-Crossing files}
\usage{
plot_zc(x, LPF = 125000, HPF = 16000, tlim = c(0, Inf),
  flim = c(HPF, LPF), ybar = TRUE, ybar.lty = 2, ybar.col = "gray",
  dot.size = 0.3, dot.col = "red", ...)
}
\arguments{
\item{x}{an object of class 'zc'.}

\item{LPF}{numeric. Low-Pass Filter (Hz). Frequencies above the cutoff are
greatly attenuated. Default is set to 125000 Hz.}

\item{HPF}{numeric. High-Pass Filter (Hz). Frequencies below the cutoff are
greatly attenuated. Default setting is 16000 Hz.}

\item{tlim}{numeric. Time limits of the plot in seconds (s). Default setting
is set to \code{c(0, Inf)}.}

\item{flim}{numeric. Frequency limits of plot in Hz. Default setting is set
to \code{c(HPF, LPF)}}

\item{ybar}{should horizontal scale bars be plotted. Default is \code{TRUE}.}

\item{ybar.lty}{line type of the horizontal scale bars.}

\item{ybar.col}{color of the horizontal scale bars.}

\item{dot.size}{dot size.}

\item{dot.col}{dot color.}

\item{...}{not currently implemented.}
}
\description{
Generate spectrogram for Zero-Crossing files.
}
\examples{
data(zc)
plot_zc(zc)
}
