% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divide_carto.R
\name{divide_carto}
\alias{divide_carto}
\title{Divide the spatial domain into subregions}
\usage{
divide_carto(carto, ID.group = NULL, k = 0, plot = FALSE)
}
\arguments{
\item{carto}{object of class \code{SpatialPolygonsDataFrame} or \code{sf}.}

\item{ID.group}{character vector of grouping identifiers.}

\item{k}{numeric value with the neighbourhood order to add polygons at the border of the spatial subdomains.
If k=0 (default) a disjoint partition is defined.}

\item{plot}{logical value (default \code{FALSE}), if \code{TRUE} then the spatial polygons within each subdomain are ploted.}
}
\value{
List of \code{sf} objects with the spatial polygons of each subdomain.
}
\description{
The function takes an object of class \code{SpatialPolygonsDataFrame} or \code{sf}
and divides it into subregions according to some grouping variable.
}
\examples{
\dontrun{
library(tmap)

## Load the Spain colorectal cancer mortality data ##
data(Carto_SpainMUN)

## Plot of the grouping variable 'region' ##
tmap4 <- packageVersion("tmap") >= "3.99"

if(tmap4){
        tm_shape(Carto_SpainMUN) +
                tm_polygons(fill="region",
                            fill.scale=tm_scale(values="brewer.set3"),
                            fill.legend=tm_legend(frame=FALSE))
}else{
        tm_shape(Carto_SpainMUN) +
                tm_polygons(col="region") +
                tm_layout(legend.outside=TRUE)
}

## Disjoint partition ##
carto.k0 <- divide_carto(carto=Carto_SpainMUN, ID.group="region", k=0)

## Partition + 1st order neighbours ##
carto.k1 <- divide_carto(carto=Carto_SpainMUN, ID.group="region", k=1)

## Partition + 2nd order neighbours ##
carto.k2 <- divide_carto(carto=Carto_SpainMUN, ID.group="region", k=2)

## Plot the spatial polygons for the autonomous region of Castilla y Leon ##
plot(carto.k2$`Castilla y Leon`$geometry, col="dodgerblue4", main="Castilla y Leon")
plot(carto.k1$`Castilla y Leon`$geometry, col="dodgerblue", add=TRUE)
plot(carto.k0$`Castilla y Leon`$geometry, col="lightgrey", add=TRUE)
}

}
