% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockBAE.R
\name{blockBAE}
\alias{blockBAE}
\title{Naïve Bayesian Adaptive Graphical Elastic Net}
\usage{
blockBAE(X, burnin = 1000, nmc = 2000, tauPrior, lambdaPrior)
}
\arguments{
\item{X}{Numeric matrix.}

\item{burnin}{An integer specifying the number of burn-in iterations.}

\item{nmc}{An integer specifying the number of MCMC samples.}

\item{tauPrior}{A numeric specifying the shrinkage hyperparameter for the off-diagonal taus.}

\item{lambdaPrior}{A numeric specifying the shrinkage hyperparameter for the off-diagonal lambdas.}
}
\value{
list containing:
\describe{
\item{Omega}{A \code{p} by \code{p} by nmc array of saved posterior samples of precision matrices.}
}
}
\description{
A naïve Bayesian adaptive graphical elastic net data-augmented block Gibbs sampler.
}
\examples{
\donttest{
# Generate true covariance matrix:
p             <- 10
n             <- 50
SigTrue       <- pracma::Toeplitz(c(0.7^rep(1:p-1)))
CTrue         <- pracma::inv(SigTrue)
# Generate expected value vector:
mu            <- rep(0,p)
# Generate multivariate normal distribution:
set.seed(123)
X             <- MASS::mvrnorm(n,mu=mu,Sigma=SigTrue)
omega_post    <- blockBAE(X,burnin = 1000,nmc = 500,tauPrior = 0.5,lambdaPrior = 0.05)
}
}
