% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology-results.R
\name{categorize_generations_rst}
\alias{categorize_generations_rst}
\title{Make a numeric generations raster categorical}
\usage{
categorize_generations_rst(
  rst,
  colors = barrks_colors(),
  labels = barrks_labels()
)
}
\arguments{
\item{rst}{A numeric SpatRaster that represents bark beetle generations.
Sister broods are defined by adding \code{0.5} to the respective generation.}

\item{colors, labels}{Vectors of colors/labels starting from zero generations followed
consecutively by elements for the respective generations (including sister broods).}
}
\value{
A categorical SpatRaster.
}
\description{
Make a numeric generations raster categorical. Useful when mathematical
operations were performed with generations rasters (use
\code{\link[=get_generations_rst]{get_generations_rst(..., categorical = FALSE)}} to get numeric generations
rasters).
}
\examples{
\donttest{
# calculate phenology with different models
p1 <- phenology('phenips-clim', barrks_data(), .quiet = TRUE)
p2 <- phenology('phenips', barrks_data(), .quiet = TRUE)

# get the generation as numerical rasters to allow mathematical operations
gens1 <- get_generations_rst(p1, categorical = FALSE)
gens2 <- get_generations_rst(p2, categorical = FALSE)

# calculate the maximum generations from the 2 models
gens_max <- max(gens1, gens2)
# categorize the results
gens_max_cat <- categorize_generations_rst(gens_max)

# plot the categorized raster
terra::plot(gens_max_cat)
# plot the uncategorized raster
terra::plot(gens_max)
}
}
