% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_covariates}
\alias{set_covariates}
\title{Specify Covariates}
\usage{
set_covariates(mod, formula)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod"},
created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{formula}{A one-sided R \link[stats:formula]{formula},
specifying the covariates.}
}
\value{
A modified version of \code{mod}
}
\description{
Add covariates to a model.
}
\details{
If \code{set_covariates()} is applied to
a model that already has covariates,
\code{set_covariates()} deletes the
existing covariates.

If \code{set_covariates()} is applied to
a fitted model, \code{set_covariates()} \link[=unfit]{unfits}
the model, deleting existing estimates.
}
\section{Covariate data}{


All variables contained in the \code{formula}
argument to \code{set_covariates()} should be in the
dataset supplied in the original call to
\code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.

\code{set_covariates()} processes the covariate data before
adding it to the model:
\itemize{
\item All numeric variables are standardized, using
\code{x <- scale(x)}.
\item Categorical variables are converted to sets of indicator
variables, using \link[stats:contrast]{treatment} contrasts.
For instance, variable \code{x} with categories
\code{"high"}, \code{"medium"}, and \code{"low"},
is converted into two indicator variables, one called \code{xmedium} and one
called \code{xlow}.
}
}

\section{Mathematical details}{


When a model includes covariates, the quantity

\deqn{\pmb{Z} \pmb{\zeta}}

is added to the linear predictor, where \eqn{\pmb{Z}}
is a matrix of standardized covariates, and \eqn{\pmb{\zeta}}
is a vector of coefficients. The elements of
\eqn{\pmb{\zeta}} have prior

\deqn{\zeta_p \sim \text{N}(0, 1)}.
}

\examples{
## create a COVID covariate
library(dplyr, warn.conflicts = FALSE)
births <- kor_births |>
  mutate(is_covid = time \%in\% 2020:2022)
mod <- mod_pois(births ~ age * region + time,
                data = births,
                exposure = popn) |>
  set_covariates(~ is_covid)
mod
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, \code{\link[=mod_norm]{mod_norm()}} Specify a
model for rates, probabilities, or means
}
}
