% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan-reference-fishbase.R
\name{scan_reference_fishbase}
\alias{scan_reference_fishbase}
\title{Scan list of references for character string for fish species}
\usage{
scan_reference_fishbase(fish, chr, mirror = "se")
}
\arguments{
\item{fish}{Vector of fish species with genus and species information.}

\item{chr}{Character string to search.}

\item{mirror}{Character string defining the url mirror to use. Defaults to \code{se}.
In case data extraction is slow use a different mirror. Try to avoid frequently used mirrors
like \code{uk} or \code{com}.}
}
\value{
Dataframe of potentially relevant references.
}
\description{
Scan list of references for character string for fish species
}
\examples{
\dontrun{
# For some reason the examples break with appveyor.
fish <- c("Gadus morhua", "Merlangius merlangus")
df <- scan_reference_fishbase(fish, chr = "diet")
df <- scan_reference_fishbase(fish, chr = "xxx")
df <- scan_reference_fishbase(fish, chr = "feed")
}
}
