% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-dietcheck.R
\name{load_dietcheck}
\alias{load_dietcheck}
\title{Read in the atlantis dietcheck.txt file and perform some basic data transformations.}
\usage{
load_dietcheck(dietcheck, fgs, prm_run, convert_names = FALSE,
  report = FALSE, version_flag = 2)
}
\arguments{
\item{dietcheck}{Character string giving the connection of the dietcheck file.
The filename usually contains \code{Dietcheck} and ends in \code{.txt}".}

\item{fgs}{Character string giving the connection to the functional groups file.
The filename usually contains \code{Groups} and does end in \code{.csv}.}

\item{prm_run}{Character string giving the connection of the run parameterfile.
The filename usually contains \code{run_fishing} and ends in \code{.prm}".}

\item{convert_names}{Logical indicating if group codes are transformed to LongNames (\code{TRUE})
or not (default = \code{FALSE}).}

\item{report}{Logical indicating if incomplete DietCheck information shall
be printed \code{TRUE} or not \code{FALSE}.}

\item{version_flag}{The version of ATLANTIS model. 1 for bec_dev, 2 for trunk. \code{default is 2.}.}
}
\value{
A \code{data.frame} in long format with the following coumn names:
  time, pred, habitat, prey and atoutput (i.e., variable).
}
\description{
Read in the atlantis dietcheck.txt file and perform some basic data transformations.
}
\examples{
# Apply to bec-dev models.
d <- system.file("extdata", "setas-model-new-becdev", package = "atlantistools")
dietcheck <- file.path(d, "outputSETASDietCheck.txt")
fgs <- file.path(d, "SETasGroups.csv")
prm_run <- file.path(d, "VMPA_setas_run_fishing_F_New.prm")

diet <- load_dietcheck(dietcheck, fgs, prm_run, version_flag = 1)
head(diet, n = 10)

# Apply to trunk models.
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
dietcheck <- file.path(d, "outputSETASDietCheck.txt")
fgs <- file.path(d, "SETasGroupsDem_NoCep.csv")
prm_run <- file.path(d, "VMPA_setas_run_fishing_F_Trunk.prm")
diet <- load_dietcheck(dietcheck, fgs, prm_run)
head(diet, n = 10)
}
\seealso{
Other load functions: \code{\link{load_box}},
  \code{\link{load_bps}}, \code{\link{load_fgs}},
  \code{\link{load_init_age}}, \code{\link{load_init}},
  \code{\link{load_nc_physics}}, \code{\link{load_nc}},
  \code{\link{load_rec}}, \code{\link{load_spec_mort}},
  \code{\link{load_txt}}
}
