% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{drop.sqlite.index}
\alias{drop.sqlite.index}
\title{Drop search index of annovarR database table in sqlite}
\usage{
drop.sqlite.index(sqlite.connect.params = list(dbname = "", table.name = ""),
  index = "", verbose = FALSE, ...)
}
\arguments{
\item{sqlite.connect.params}{Connect to sqlite database params [dbname]}

\item{index}{Index name in sqlite}

\item{verbose}{Ligical indicating wheather show the log message}

\item{...}{Other parameters be used in dbSendQuery}
}
\description{
Drop search index of annovarR database table in sqlite
}
\examples{
test.sqlite <- sprintf('\%s/snp.test.sqlite', tempdir())
test.dat <- system.file('extdata', 'demo/sqlite.dat.txt', package = 'annovarR')
x <- sqlite.build(filename = test.dat, list(dbname = test.sqlite, 
table.name = 'snp_test'))
x <- sqlite.index(list(dbname = test.sqlite, table.name = 'snp_test'), 
index = 'index4', cols = c('V1', 'V2'))
x <- drop.sqlite.index(list(dbname = test.sqlite, table.name = 'snp_test'), index = 'index4')
test.sqlite <- normalizePath(test.sqlite, '/')
file.remove(test.sqlite)
}
