% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_pages.R
\name{animint2pages}
\alias{animint2pages}
\title{Publish a list of ggplots as interactive visualizations on a GitHub repository}
\usage{
animint2pages(
  plot.list,
  github_repo,
  owner = NULL,
  commit_message = "Commit from animint2pages",
  private = FALSE,
  required_opts = c("title", "source"),
  chromote_sleep_seconds = NULL,
  ...
)
}
\arguments{
\item{plot.list}{A named list of ggplots and option lists.}

\item{github_repo}{The name of the GitHub repository to which the
files will be pushed.}

\item{owner}{The user/org under which the repo will be created, default comes from \code{gh::gh_whoami}.}

\item{commit_message}{A string specifying the commit message for
the pushed files.}

\item{private}{A logical flag indicating whether the GitHub
repository should be private or not (default FALSE).}

\item{required_opts}{Character vector of plot.list element names
which are checked (stop with an error if not present). Use
required_opts=NULL to skip check.}

\item{chromote_sleep_seconds}{if numeric, chromote will be used to take a screenshot of the data viz, pausing this number of seconds to wait for rendering (experimental).}

\item{...}{Additional options passed onto \code{animint2dir}.}
}
\value{
The function returns the initialized GitHub repository object.
}
\description{
This function takes a named list of ggplots, generates interactive animations,
and pushes the generated files to a specified GitHub repository. You can
choose to keep the repository private or public.
Before using this function set your appropriate git 'user.username' and 'user.email'
}
\examples{
\dontrun{
library(animint2)
mtcars$Cyl <- factor(mtcars$cyl)
viz <- animint(
  ggplot(mtcars, aes(x = mpg, y = disp, color=Cyl)) +
    geom_point(),
  ggplot(mtcars, aes(x = hp, y = wt, color=Cyl)) +
    geom_point(),
  title="Motor Trend Cars data viz",
  source="https://github.com/animint/animint2/blob/master/R/z_pages.R"
)
animint2pages(viz, "animint2pages-example-mtcars")
}

}
