% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_terraclimate}
\alias{download_terraclimate}
\title{Download TerraClimate data}
\usage{
download_terraclimate(
  variables = NULL,
  year = c(2018, 2022),
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  hash = FALSE
)
}
\arguments{
\item{variables}{character(1). Variable(s) name(s). See \href{https://climate.northwestknowledge.net/TERRACLIMATE/index_directDownloads.php}{TerraClimate Direct Downloads}
for variable names and acronym codes.}

\item{year}{character(1 or 2). length of 4. Year or start/end years for downloading data.}

\item{directory_to_save}{character(1). Directory(s) to save downloaded data
files.}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). \code{FALSE} will generate a *.txt file
containing all download commands. By setting \code{TRUE} the function
will download all of the requested data files.}

\item{remove_command}{logical(1).
Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}

\item{hash}{logical(1). By setting \code{TRUE} the function will return
an \code{rlang::hash_file()} hash character corresponding to the
downloaded files. Default is \code{FALSE}.}
}
\value{
\itemize{
\item For \code{hash = FALSE}, NULL
\item For \code{hash = TRUE}, an \code{rlang::hash_file} character.
\item netCDF (.nc) files will be stored in a variable-specific
folder within \code{directory_to_save}.
}
}
\description{
The \code{download_terraclimate} function accesses and downloads climate and water balance data from the \href{https://www.climatologylab.org/terraclimate.html}{University of California Merced Climatology Lab's TerraClimate dataset}.
}
\examples{
\dontrun{
download_terraclimate(
  variables = "Precipitation",
  year = 2023,
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE
)
}
}
\references{
\insertRef{article_abatzoglou2018terraclimate}{amadeus}
}
\author{
Mitchell Manware, Insang Song
}
