% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_DocumentationDesc.R
\name{get_layer_documentation}
\alias{get_layer_documentation}
\title{Generate layer documentation}
\usage{
get_layer_documentation(
  layer_name,
  title_format = "bold",
  subtitle_format = "italic",
  inc_img = FALSE,
  inc_params = FALSE,
  inc_references = FALSE
)
}
\arguments{
\item{layer_name}{\code{string} Name of the layer.}

\item{title_format}{\code{string} Kind of format of the title.}

\item{subtitle_format}{\code{string} Kind of format for all sub-titles.}

\item{inc_img}{\code{bool} Include a visualization of the layer.}

\item{inc_params}{\code{bool} Include a description of every parameter of the layer.}

\item{inc_references}{\code{bool} Include a list of literature references for the layer.}
}
\value{
Returns a \code{string} containing the description written in rmarkdown.
}
\description{
Function for generating the documentation of a specific layer.
}
\seealso{
Other Utils Documentation: 
\code{\link{build_documentation_for_model}()},
\code{\link{build_layer_stack_documentation_for_vignette}()},
\code{\link{get_desc_for_core_model_architecture}()},
\code{\link{get_dict_cls_type}()},
\code{\link{get_dict_core_models}()},
\code{\link{get_dict_input_types}()},
\code{\link{get_layer_dict}()},
\code{\link{get_parameter_documentation}()}
}
\concept{Utils Documentation}
