% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalFtest.R
\name{globalFtest}
\alias{globalFtest}
\title{global F test for Wasserstein regression}
\usage{
globalFtest(
  wass_regress_res,
  alpha = 0.05,
  permutation = FALSE,
  numPermu = 200,
  bootstrap = FALSE,
  numBoot = 200
)
}
\arguments{
\item{wass_regress_res}{an object returned by the \code{wass_regress} function}

\item{alpha}{type one error rate}

\item{permutation}{logical; perform permutation global F test (default: FALSE)}

\item{numPermu}{number of permutation samples if permutation = TRUE}

\item{bootstrap}{logical; bootstrap global F test (default: FALSE)}

\item{numBoot}{number of bootstrap samples if bootstrap = TRUE}
}
\value{
a list containing the following fields:
\item{wasserstein.F_stat}{the Wasserstein F statistic value in Satterthwaite method .}
\item{chisq_df}{the degree of freedom of the null chi-square distribution.}
\item{summary_df}{a dataframe containing the following columns:}
\itemize{
\item{method:} {methods used to compute p value, see details}
\item{statistic:} {the test statistics}
\item{critical_value:} {critical value}
\item{p_value:} {p value of global F test}}
}
\description{
global F test for Wasserstein regression
}
\details{
four methods used to compute p value of global F test
\itemize{
\item{truncated:}{ asymptotic inference,  p-value is obtained by truncating the infinite summation of eigenvalues into the first K terms, where the first K terms explain more than 99.99\% of the variance.}
\item{satterthwaite:}{ asymptotic inference, p-value is computed using Satterthwaite's approximation method of mixtures of chi-square.}
\item{permutation:}{ resampling technique; Wasserstein SSR is used as the F statistic.}
\item{bootstrap:}{ resampling technique; Wasserstein SSR is used as the F statistic.}}
}
\examples{
data(strokeCTdensity)
predictor = strokeCTdensity$predictors
dSup = strokeCTdensity$densitySupport
densityCurves = strokeCTdensity$densityCurve

res = wass_regress(rightside_formula = ~., Xfit_df = predictor,
 Ytype = 'density', Ymat = densityCurves, Sup = dSup)
globalF_res = globalFtest(res, alpha = 0.05, permutation = TRUE, numPermu = 200)
}
