% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{CDsXML}
\alias{CDsXML}
\title{Import catchment descriptors from .xml files}
\usage{
CDsXML(x)
}
\arguments{
\item{x}{the xml file path}
}
\value{
A data.frame with columns; Descriptor and Value.
}
\description{
Imports catchment descriptors from xml files either from an FEH webservice download or from the Peakflows dataset downloaded from the national river flow archive (NRFA) website
}
\details{
File paths for importing data require forward slashes. On some operating systems, such as windows, the copy and pasted file paths will have backward slashes and would need to be changed accordingly.
}
\examples{
# Import catchment descriptors from an NRFA Peak Flows XML file and display in console
\dontrun{
cds_4003 <- CDsXML("C:/Data/NRFAPeakFlow_v11/Suitable for QMED/4003.xml")
cds_4003
}

# Import catchment descriptors from a FEH webserver XML file and display XML in the console
\dontrun{
cds_my_site <- CDsXML("C:/Data/FEH_Catchment_384200_458200.xml")
cds_my_site
}

}
\author{
Anthony Hammond
}
