% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{UncSS}
\alias{UncSS}
\title{Uncertainty for the single site}
\usage{
UncSS(x, func, conf = 0.95, RP = FALSE)
}
\arguments{
\item{x}{a numeric vector. The sample of interest}

\item{func}{the function to be applied}

\item{conf}{the confidence level of the intervals}

\item{RP}{return period. Necessary if func requires RP}
}
\value{
A data.frame of three values; central, lower, and upper bootstrapped estimates.
}
\description{
Quantifies the aleatoric uncertainty for a single site estimate, by bootstrapping the sample
}
\details{
The bootstrapping procedure resamples from a sample N*500 times with replacement. After splitting into 500 samples of size N, the statsitic of interest is calculated on each. upper and lower quantiles of the resulting distribution are used as the quantification of uncertainty. Any function that provides an estimate based on a sample of data can be used. Including any function that provides estimates as a function of return period.
}
\examples{
#Extract an AMAX sample and quantify uncertainty for the GEV estimated 50-year flow
AM.203018 <- GetAM(203018)
UncSS(AM.203018$Flow, func = GEVAM, RP = 50)
#Quantify uncertainty for the sample standard deviation at the 90 percent confidence level
UncSS(AM.203018$Flow, func = sd, conf = 0.90)
}
\author{
Anthony Hammond
}
